/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.Numbers;

public class KorennPassModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(KorennPassModule.class);
    List<TagAddr> tas = new ArrayList<TagAddr>();
    protected Tag tagSumWeight;
    protected Tag tagSumNum;
    protected Tag tagLastTime;
    protected Tag tagReqOutput;
    protected Tag tagCurOutput;
    private int[] bufout = new int[9];
    private int[] bufin = new int[15];

    public KorennPassModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagSumWeight = this.createTagAddr(Tag.Type.LONG, "SumWeight", 34);
        this.tagSumNum = this.createTagAddr(Tag.Type.INT, "SumNum", 36);
        this.tagLastTime = this.createTagAddr(Tag.Type.INT, "LastTime", 49);
        this.tagReqOutput = this.createTagAddr(Tag.Type.INT, "ReqOutput", 47);
        this.tagCurOutput = this.createTagAddr(Tag.Type.INT, "CurOutput", 45);
        return true;
    }

    private Tag createTagAddr(Tag.Type tagtype, String tagname, int addr) {
        Tag tag = this.tagtable.createTag(tagtype, tagname, 8);
        TagAddr ta = new TagAddr();
        ta.tag = tag;
        ta.addr = addr;
        this.tas.add(ta);
        return tag;
    }

    boolean request(int addr) throws Exception {
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            this.port.discard();
            this.delayBeforeWrite();
            this.bufout[0] = 35;
            Numbers.intToHexByte(this.netaddr, this.bufout, 1);
            this.bufout[3] = 48;
            this.bufout[4] = 53;
            Numbers.intToHexByte(addr, this.bufout, 5);
            this.bufout[7] = 13;
            this.bufout[8] = 10;
            this.port.writeBytes(this.bufout, this.bufout.length);
            int cntRead = 0;
            cntRead = this.port.readBytes(this.bufin, this.bufin.length);
            if (cntRead == this.bufin.length && this.bufin[0] == 64 && Numbers.asciiByteToInt(this.bufin, 1) == this.netaddr && this.checkCrc()) {
                return true;
            }
            if (this.canLogError()) {
                this.logError(trynum, this.checkCrc(), this.bufout, this.bufout.length, this.bufin, cntRead, "");
            }
            this.delayAfterError();
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }

    private boolean checkCrc() {
        int sum = 0;
        for (int i = 1; i < 11; i += 2) {
            sum += Numbers.asciiByteToInt(this.bufin, i);
        }
        return (sum = 256 - (sum & 0xFF)) == Numbers.asciiByteToInt(this.bufin, 11);
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            for (TagAddr ta : this.tas) {
                if (ta.addr == 0) continue;
                result = this.request(ta.addr);
                if (result) {
                    if (ta.tag.getType() == Tag.Type.LONG) {
                        ta.tag.setLong(Numbers.asciiDWordToLong(this.bufin, 3));
                        continue;
                    }
                    ta.tag.setInt(Numbers.asciiWordToInt(this.bufin, 7));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    private static class TagAddr {
        Tag tag;
        int addr;

        private TagAddr() {
        }
    }
}

