/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenPVT100Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenPVT100Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected TagRW tag_RegReload;
    protected Tag tag_RegTempr;
    protected Tag tag_RegRH;
    protected Tag tag_RegDewPnt;

    public OwenPVT100Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tag_RegTempr = this.tagtable.createInt("Tempr", 0, 8);
        this.tag_RegRH = this.tagtable.createInt("RH", 0, 8);
        this.tag_RegDewPnt = this.tagtable.createInt("DewPnt", 0, 8);
        this.tag_RegReload = this.protocol.addWriteTag(17, this.tagtable.createRWInt("RLD", 0, 8));
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tag_RegReload.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.sendWriteTags(6);
            if (result) {
                result = this.protocol.requestCmd3(258, 3);
                if (result) {
                    this.tag_RegTempr.setInt((short)this.protocol.getAnswerWord(0));
                    this.tag_RegRH.setInt(this.protocol.getAnswerWord(1));
                    this.tag_RegDewPnt.setInt(this.protocol.getAnswerWord(2));
                }
                if (result = this.protocol.requestCmd3(17, 1)) {
                    this.tag_RegReload.setReadValInt(this.protocol.getAnswerWord(0));
                }
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

