/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenTrm210Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenTrm210Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagLvoPSTAT;
    protected Tag tagLvoPPV;
    protected TagRW tagLvoPSP;
    protected Tag tagLvoPSETP;
    protected Tag tagLvoPO;
    protected TagRW tagLvoPrL;
    protected TagRW tagLvoProut;
    protected TagRW tagLvoPRS;
    protected TagRW tagLvoPAT;
    protected TagRW tagOLL;
    protected TagRW tagOLH;
    protected TagRW tagSLL;
    protected TagRW tagSLH;
    protected TagRW tagorEU;
    protected TagRW tagCntL;

    public OwenTrm210Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagLvoPSTAT = this.tagtable.createInt("LvoP.STAT", 0, 8);
        this.tagLvoPPV = this.tagtable.createInt("LvoP.PV", 0, 8);
        this.tagLvoPSP = this.protocol.addWriteTag(2, this.tagtable.createRWInt("LvoP.SP", 0, 8));
        this.tagLvoPSETP = this.tagtable.createInt("LvoP.SET.P", 0, 8);
        this.tagLvoPO = this.tagtable.createInt("LvoP.O", 0, 8);
        this.tagLvoPrL = this.protocol.addWriteTag(5, this.tagtable.createRWInt("LvoP.r-L", 0, 8));
        this.tagLvoProut = this.protocol.addWriteTag(6, this.tagtable.createRWInt("LvoP.r.out", 0, 8));
        this.tagLvoPRS = this.protocol.addWriteTag(7, this.tagtable.createRWInt("LvoP.R-S", 0, 8));
        this.tagLvoPAT = this.protocol.addWriteTag(8, this.tagtable.createRWInt("LvoP.AT", 0, 8));
        this.tagSLL = this.protocol.addWriteTag(768, this.tagtable.createRWInt("SL-L", 0, 8));
        this.tagSLH = this.protocol.addWriteTag(769, this.tagtable.createRWInt("SL-H", 0, 8));
        this.tagorEU = this.protocol.addWriteTag(770, this.tagtable.createRWInt("orEU", 0, 8));
        this.tagCntL = this.protocol.addWriteTag(771, this.tagtable.createRWInt("CntL", 0, 8));
        this.tagOLL = this.protocol.addWriteTag(779, this.tagtable.createRWInt("OL-L", 0, 8));
        this.tagOLH = this.protocol.addWriteTag(780, this.tagtable.createRWInt("OL-H", 0, 8));
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        this.addChannelMapTag(chtags, this.tagLvoPPV, "0");
        this.addChannelMapTag(chtags, this.tagLvoPSP, "sp0");
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagLvoPSP.acceptWriteValue();
            this.tagLvoPrL.acceptWriteValue();
            this.tagLvoProut.acceptWriteValue();
            this.tagLvoPRS.acceptWriteValue();
            this.tagLvoPAT.acceptWriteValue();
            this.tagOLL.acceptWriteValue();
            this.tagOLH.acceptWriteValue();
            this.tagSLL.acceptWriteValue();
            this.tagSLH.acceptWriteValue();
            this.tagorEU.acceptWriteValue();
            this.tagCntL.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.sendWriteTags(16);
            if (result && (result = this.protocol.requestCmd3(0, 9))) {
                this.tagLvoPSTAT.setInt(this.protocol.getAnswerWord(0));
                this.tagLvoPPV.setInt(this.protocol.getAnswerWord(1));
                this.tagLvoPSP.setReadValInt(this.protocol.getAnswerWord(2));
                this.tagLvoPSETP.setInt(this.protocol.getAnswerWord(3));
                this.tagLvoPO.setInt(this.protocol.getAnswerWord(4));
                this.tagLvoPrL.setReadValInt(this.protocol.getAnswerWord(5));
                this.tagLvoProut.setReadValInt(this.protocol.getAnswerWord(6));
                this.tagLvoPRS.setReadValInt(this.protocol.getAnswerWord(7));
                this.tagLvoPAT.setReadValInt(this.protocol.getAnswerWord(8));
            }
            if (result && (result = this.protocol.requestCmd3(768, 4))) {
                this.tagSLL.setReadValInt(this.protocol.getAnswerWord(0));
                this.tagSLH.setReadValInt(this.protocol.getAnswerWord(1));
                this.tagorEU.setReadValInt(this.protocol.getAnswerWord(2));
                this.tagCntL.setReadValInt(this.protocol.getAnswerWord(3));
            }
            if (result && (result = this.protocol.requestCmd3(779, 2))) {
                this.tagOLL.setReadValInt(this.protocol.getAnswerWord(0));
                this.tagOLH.setReadValInt(this.protocol.getAnswerWord(1));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

