/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.Numbers;
import promauto.utils.Strings;

public class ProtocolIcpcon {
    private PeripherialModule module;

    public ProtocolIcpcon(PeripherialModule module) {
        this.module = module;
    }

    private int calcCrc(int[] data, int size) {
        int crc = 0;
        for (int i = 0; i < size; ++i) {
            crc += data[i];
        }
        return crc & 0xFF;
    }

    public int request(int[] buffout, int sizeout, int[] buffin, int sizein) throws Exception {
        Numbers.intToHexByte(this.module.netaddr, buffout, 1);
        int crcout = this.calcCrc(buffout, sizeout);
        Numbers.intToHexByte(crcout, buffout, sizeout);
        buffout[(sizeout += 3) - 1] = 13;
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(buffout, sizeout);
            boolean badcrc = false;
            int n = this.module.port.readBytes(buffin, sizein);
            if (n >= 3) {
                int crc2;
                int crc1 = Numbers.asciiByteToInt(buffin, n - 3);
                if (crc1 == (crc2 = this.calcCrc(buffin, n - 3))) {
                    return n;
                }
                badcrc = true;
            }
            if (this.module.canLogError()) {
                int cntRead = Math.abs(n);
                this.module.logError(trynum, badcrc, buffout, sizeout, buffin, cntRead, new String(Strings.intsToBytes(buffin, cntRead)));
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return -1;
    }
}

