/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;

public class ProtocolKontakt1 {
    private int TMPR_CNT_MAX = 30;
    private int buffinSize = this.calcTmprPackageLen(this.TMPR_CNT_MAX);
    private int buffoutSize = 6;
    protected int[] buffin = new int[this.buffinSize];
    protected int[] buffout = new int[this.buffoutSize];
    private PeripherialModule module;

    public ProtocolKontakt1(PeripherialModule module) {
        this.module = module;
    }

    public void setupBuffIn(int tmprCnt) {
        int n = this.calcTmprPackageLen(tmprCnt);
        if (n > this.buffinSize) {
            this.buffinSize = n;
            this.buffin = new int[this.buffinSize];
        }
    }

    public int calcTmprPackageLen(int tmprCnt) {
        return 5 + 2 * tmprCnt;
    }

    public boolean request(int sizeout, int sizein) throws Exception {
        if (sizeout > this.buffoutSize || sizein > this.buffinSize) {
            return false;
        }
        this.buffout[0] = this.module.netaddr;
        int crc = CRC.getCrc16(this.buffout, sizeout - 2);
        this.buffout[sizeout - 2] = crc & 0xFF;
        this.buffout[sizeout - 1] = crc >> 8 & 0xFF;
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(this.buffout, sizeout);
            int n = this.module.port.readBytes(this.buffin, sizein);
            boolean badcrc = false;
            if (n == sizein) {
                int crc2;
                int crc1 = CRC.getCrc16(this.buffin, sizein - 2);
                if (crc1 == (crc2 = this.buffin[sizein - 1] << 8 | this.buffin[sizein - 2])) {
                    return true;
                }
                badcrc = true;
            }
            if (this.module.canLogError()) {
                int cntRead = Math.abs(n);
                this.module.logError(trynum, badcrc, this.buffout, sizeout, this.buffin, n, "");
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }
}

