/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class ProtocolModbus {
    public Charset charset = Charset.forName("UTF-8");
    private PeripherialModule module;
    protected int[] buffin = null;
    protected int[] buffout = null;
    protected List<WriteTag> writeTags = null;
    private final byte[] buffbytes = new byte[4];
    private static final Charset charsetWIN1251 = Charset.forName("windows-1251");
    private static final char[] tableGeliosChars = new char[]{'\u0411', '\u0413', '\u0401', '\u0416', '\u0417', '\u0418', '\u0419', '\u041b', '\u041f', '\u0423', '\u0424', '\u0427', '\u0428', '\u042a', '\u042b', '\u042d', '\u042e', '\u042f', '\u0431', '\u0432', '\u0433', '\u0451', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043f', '\u0442', '\u0447', '\u0448', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f', '\u00bb', '\u0414', '\u0426', '\u0429', '\u0434', '\u0444', '\u0446', '\u0449'};
    private static final int[] tableGeliosBytes = new int[]{160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 219, 224, 225, 226, 227, 228, 229, 230};

    public ProtocolModbus(PeripherialModule module) {
        this.module = module;
    }

    public TagRW addWriteTag(int addr, TagRW tag) {
        if (this.writeTags == null) {
            this.writeTags = new LinkedList<WriteTag>();
        }
        this.writeTags.add(new WriteTag(addr, tag));
        return tag;
    }

    public boolean requestCmd1(int addr, int size) throws Exception {
        int m = size / 8 + (size % 8 > 0 ? 1 : 0);
        int sizeout = 8;
        int sizein = 5 + m;
        this.adjustBuffers(8, sizein);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 1;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = size >> 8 & 0xFF;
        this.buffout[5] = size & 0xFF;
        return this.request(8, sizein, true);
    }

    public boolean requestCmd2(int addr, int size) throws Exception {
        int m = size / 8 + (size % 8 > 0 ? 1 : 0);
        int sizeout = 8;
        int sizein = 5 + m;
        this.adjustBuffers(8, sizein);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 2;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = size >> 8 & 0xFF;
        this.buffout[5] = size & 0xFF;
        return this.request(8, sizein, true);
    }

    public boolean requestCmd3(int addr, int size) throws Exception {
        int sizeout = 8;
        int sizein = size * 2 + 5;
        this.adjustBuffers(8, sizein);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 3;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = size >> 8 & 0xFF;
        this.buffout[5] = size & 0xFF;
        return this.request(8, sizein, true);
    }

    public boolean requestEasyDriveCmd3(int addr) throws Exception {
        int sizeout = 8;
        int sizein = 10;
        this.adjustBuffers(8, 10);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 3;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = 0;
        this.buffout[5] = 0;
        return this.request(8, 10, true);
    }

    public boolean requestEasyDriveCmd10(int addr, int value) throws Exception {
        int sizeout = 13;
        int sizein = 8;
        this.adjustBuffers(13, 8);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 16;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = 0;
        this.buffout[5] = 2;
        this.buffout[6] = 4;
        this.buffout[7] = value >> 8 & 0xFF;
        this.buffout[8] = value & 0xFF;
        this.buffout[9] = 0;
        this.buffout[10] = 0;
        return this.request(13, 8, false);
    }

    public boolean requestCmd4(int addr, int size) throws Exception {
        int sizeout = 8;
        int sizein = size * 2 + 5;
        this.adjustBuffers(8, sizein);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 4;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = size >> 8 & 0xFF;
        this.buffout[5] = size & 0xFF;
        return this.request(8, sizein, true);
    }

    public boolean requestCmd5(int addr, int value) throws Exception {
        int sizeout = 8;
        int sizein = 8;
        this.adjustBuffers(8, 8);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 5;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = value > 0 ? 255 : 0;
        this.buffout[5] = 0;
        return this.request(8, 8, false);
    }

    public boolean requestCmd6(int addr, int value) throws Exception {
        int cmd = 6;
        int sizeout = 8;
        int sizein = 8;
        this.adjustBuffers(8, 8);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 6;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = value >> 8 & 0xFF;
        this.buffout[5] = value & 0xFF;
        return this.request(8, 8, false);
    }

    public boolean requestCmd0F(int addr, int size, int ... values) throws Exception {
        size = Math.min(values.length, size);
        int m = size / 8 + (size % 8 > 0 ? 1 : 0);
        int sizeout = 9 + m;
        int sizein = 8;
        this.adjustBuffers(sizeout, 8);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 15;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = size >> 8 & 0xFF;
        this.buffout[5] = size & 0xFF;
        this.buffout[6] = m;
        int mask = 256;
        int pos = 6;
        for (int i = 0; i < size; ++i) {
            if (mask == 256) {
                mask = 1;
                this.buffout[++pos] = 0;
            }
            int n = pos;
            this.buffout[n] = this.buffout[n] | (values[i] > 0 ? mask : 0);
            mask <<= 1;
        }
        return this.request(sizeout, 8, false);
    }

    public boolean requestCmd10(int addr, int size, int ... values) throws Exception {
        size = Math.min(values.length, size);
        int sizeout = 9 + size * 2;
        int sizein = 8;
        this.adjustBuffers(sizeout, 8);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 16;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = size >> 8 & 0xFF;
        this.buffout[5] = size & 0xFF;
        this.buffout[6] = size * 2;
        for (int i = 0; i < size; ++i) {
            this.buffout[7 + i * 2] = values[i] >> 8 & 0xFF;
            this.buffout[8 + i * 2] = values[i] & 0xFF;
        }
        return this.request(sizeout, 8, false);
    }

    public boolean requestCmd10(int addr, int size, long ... values) throws Exception {
        size = Math.min(values.length, size);
        int sizeout = 9 + size * 4;
        int sizein = 8;
        this.adjustBuffers(sizeout, 8);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 16;
        this.buffout[2] = addr >> 8 & 0xFF;
        this.buffout[3] = addr & 0xFF;
        this.buffout[4] = size * 2 >> 8 & 0xFF;
        this.buffout[5] = size * 2 & 0xFF;
        this.buffout[6] = size * 4;
        for (int i = 0; i < size; ++i) {
            this.buffout[7 + i * 4] = (int)(values[i] >> 24 & 0xFFL);
            this.buffout[8 + i * 4] = (int)(values[i] >> 16 & 0xFFL);
            this.buffout[9 + i * 4] = (int)(values[i] >> 8 & 0xFFL);
            this.buffout[10 + i * 4] = (int)(values[i] & 0xFFL);
        }
        return this.request(sizeout, 8, false);
    }

    public void adjustBuffers(int sizeout, int sizein) {
        if (this.buffout == null || this.buffout.length < sizeout) {
            this.buffout = new int[sizeout];
        }
        if (this.buffin == null || this.buffin.length < sizein) {
            this.buffin = new int[sizein];
        }
    }

    private boolean request(int sizeout, int sizein, boolean checkBadReq) throws Exception {
        int crc = CRC.getCrc16(this.buffout, sizeout - 2);
        this.buffout[sizeout - 2] = crc & 0xFF;
        this.buffout[sizeout - 1] = crc >> 8 & 0xFF;
        int b = 0;
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(this.buffout, sizeout);
            int cntRead = 0;
            boolean badcrc = false;
            boolean badreq = false;
            for (int i = 0; i < sizein && (b = this.module.port.readByte()) >= 0; ++i) {
                this.buffin[i] = b;
                if (i == 1 && (b & 0x80) > 0) {
                    sizein = 5;
                    badreq = true;
                }
                ++cntRead;
            }
            if (b >= 0) {
                int crc2;
                int crc1 = CRC.getCrc16(this.buffin, sizein - 2);
                if (crc1 != (crc2 = this.buffin[sizein - 1] << 8 | this.buffin[sizein - 2])) {
                    badcrc = true;
                } else if (!(this.buffout[0] != this.buffin[0] || checkBadReq && badreq)) {
                    if (this.module.canLogReq()) {
                        this.module.logReq(this.buffout, sizeout, this.buffin, sizein);
                    }
                    return true;
                }
            }
            if (this.module.canLogError()) {
                this.module.logError(trynum, badcrc, this.buffout, sizeout, this.buffin, cntRead, badreq ? "BadRequest" : "");
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }

    public boolean sendWriteTags(int cmd) throws Exception {
        if (this.writeTags == null) {
            return true;
        }
        boolean result = true;
        for (WriteTag wt : this.writeTags) {
            if (!wt.tag.hasWriteValue()) continue;
            int value = wt.tag.getWriteValInt();
            if (cmd == 6) {
                result = this.requestCmd6(wt.addr, value);
            } else if (cmd == 16) {
                result = this.requestCmd10(wt.addr, 1, value);
            } else {
                return false;
            }
            if (!result) break;
            wt.tag.setReadValInt(value);
        }
        return result;
    }

    public int getAnswerWord(int num) {
        return Numbers.bytesToWord(this.buffin, 3 + (num << 1));
    }

    public int getAnswerInt32(int num) {
        return this.getAnswerInt32(num, false);
    }

    public int getAnswerInt32(int num, boolean littleEndian) {
        if (littleEndian) {
            return (this.getAnswerWord(num + 1) << 16) + this.getAnswerWord(num);
        }
        return (this.getAnswerWord(num) << 16) + this.getAnswerWord(num + 1);
    }

    public long getAnswerUInt32(int num) {
        return this.getAnswerUInt32(num, false);
    }

    public long getAnswerUInt32(int num, boolean littleEndian) {
        if (littleEndian) {
            return ((long)this.getAnswerWord(num + 1) << 16) + (long)this.getAnswerWord(num);
        }
        return ((long)this.getAnswerWord(num) << 16) + (long)this.getAnswerWord(num + 1);
    }

    public int getAnswerBit(int num) {
        int pos = 3 + num / 8;
        int mask = 1 << num % 8;
        return (this.buffin[pos] & mask) > 0 ? 1 : 0;
    }

    public float getAnswerFloat(int num) {
        int k = 3 + (num << 1);
        for (int i = 0; i < 4; ++i) {
            this.buffbytes[i] = (byte)this.buffin[k + i];
        }
        return ByteBuffer.wrap(this.buffbytes).getFloat();
    }

    public String getAnswerString(int pos, int size) {
        int ofs = pos * 2 + 3;
        int n = size * 2;
        byte[] bytes = new byte[n];
        for (int i = 0; i < n; ++i) {
            bytes[i] = (byte)this.buffin[ofs + i];
        }
        return new String(bytes, this.charset);
    }

    public String getAnswerGeliosString(int pos, int size) {
        int ofs = pos * 2 + 3;
        int n = size * 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            int b = this.buffin[ofs + i];
            if (b <= 0) continue;
            sb.append(this.decodeGeliosChar(b));
        }
        return sb.toString();
    }

    private char decodeGeliosChar(int b) {
        if (b < tableGeliosBytes[0]) {
            return (char)b;
        }
        if (b > tableGeliosBytes[tableGeliosBytes.length - 1]) {
            return (char)b;
        }
        int found = Arrays.binarySearch(tableGeliosBytes, b);
        if (found < 0) {
            return (char)b;
        }
        return tableGeliosChars[found];
    }

    public static class WriteTag {
        int addr;
        TagRW tag;

        public WriteTag(int addr, TagRW tag) {
            this.addr = addr;
            this.tag = tag;
        }
    }
}

