/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceLOADB
extends Device {
    private static final int SIZE = 16;
    protected List<Item> items = new ArrayList<Item>();
    Input inpEnable;
    Tag tagCurrent;
    Tag tagChanging;
    Tag tagDlyChange;
    Tag tagFlags;
    Tag tagOutput0;
    int current = 0;
    int changecnt = 0;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpEnable = this.getInput("Enable", res);
        this.tagCurrent = this.getOutputTag("Current", res);
        this.tagChanging = this.getOutputTag("Changing", res);
        this.tagDlyChange = this.getOutputTag("DlyChange", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagOutput0 = this.getOutputTag("Output0", res);
        this.items.clear();
        int i = 1;
        while (i <= 16) {
            Item it = new Item();
            it.tagOutput = this.getOutputTag("Output" + i, res);
            it.tagSelect = this.getOutputTag("Select" + i, res);
            it.index = i++;
            it.select = false;
            this.items.add(it);
        }
    }

    @Override
    public boolean execute() {
        boolean select;
        if (this.tagCurrent.getInt() < 0 || this.tagCurrent.getInt() > 16) {
            this.tagCurrent.setInt(this.current);
        }
        int oldcur = this.current;
        if (this.current != this.tagCurrent.getInt()) {
            this.current = this.tagCurrent.getInt();
        } else {
            for (Item it : this.items) {
                select = it.tagSelect.getBool();
                if (select) {
                    if (it.select) continue;
                    this.current = it.index;
                    continue;
                }
                if (this.current != it.index) continue;
                this.current = 0;
            }
        }
        this.tagCurrent.setInt(this.current);
        if (this.current != oldcur && this.current > 0) {
            this.changecnt = this.tagDlyChange.getInt();
        }
        this.tagChanging.setBool(this.changecnt > 0);
        for (Item it : this.items) {
            select = it.index == this.current;
            it.tagSelect.setBool(select);
            it.select = select;
            if (this.inpEnable.getInt() == 0) {
                it.tagOutput.setInt(0);
                continue;
            }
            if (this.changecnt != 0) continue;
            it.tagOutput.setBool(select);
        }
        if (this.changecnt == 0) {
            this.tagOutput0.setBool(this.current == 0 && this.inpEnable.getInt() > 0);
        } else {
            --this.changecnt;
        }
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("current", this.current);
        state.saveVar("changecnt", this.changecnt);
        for (Item it : this.items) {
            state.saveVar("select" + it.index, it.select);
        }
    }

    @Override
    public void loadStateExtra(State state) {
        this.current = state.loadVar("current", this.current);
        this.changecnt = state.loadVar("changecnt", this.changecnt);
        for (Item it : this.items) {
            it.select = state.loadVar("select" + it.index, it.select);
        }
    }

    protected static class Item {
        Tag tagOutput;
        Tag tagSelect;
        int index;
        boolean select;

        protected Item() {
        }
    }
}

