/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.HashMap;
import java.util.Map;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceSTEPPER
extends Device {
    private static int STEPPER_STATE_STOP = 0;
    private static int STEPPER_STATE_OUTTER = 1;
    private static int STEPPER_STATE_START = 2;
    private static int STEPPER_STATE_WORK_INC = 3;
    private static int STEPPER_STATE_WORK_DEC = 4;
    private static int STEPPER_STATE_ALM = 5;
    Input inpEnable;
    Input inpCurTmp;
    Input inpStartOut;
    Input inpError;
    Tag tagOutVal;
    Tag tagState;
    Tag tagFlags;
    Tag tagMinOut;
    Tag tagMaxOut;
    Tag tagIncStep;
    Tag tagDecStep;
    Tag tagMaxTmp;
    Tag tagMinTmp;
    Tag tagAlmTHgh;
    Tag tagAlmTLow;
    Tag tagAlmTDelta;
    Tag tagTimeOnInc;
    Tag tagTimeOnDec;
    Tag tagOldMaxTmp;
    Tag tagTimeCnt;
    Tag tagIncDecSost;
    int iOutVal;
    int iState;
    int iOldMaxTmp;
    int iUpCnt;
    int iDwnCnt;
    boolean bFlIncDecAllow;
    Map<Integer, Runnable> commands = new HashMap<Integer, Runnable>();

    @Override
    protected void prepareTags(Device.RefBool res) {
        this.iOutVal = 0;
        this.iState = 0;
        this.iOldMaxTmp = 0;
        this.iUpCnt = 0;
        this.iDwnCnt = 0;
        this.inpEnable = this.getInput("Enable", res);
        this.inpCurTmp = this.getInput("CurTmp", res);
        this.inpStartOut = this.getInput("StartOut", res);
        this.inpError = this.getInput("Error", res);
        this.tagOutVal = this.getOutputTag("OutVal", res);
        this.tagState = this.getOutputTag("State", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagMinOut = this.getOutputTag("MinOut", res);
        this.tagMaxOut = this.getOutputTag("MaxOut", res);
        this.tagIncStep = this.getOutputTag("IncStep", res);
        this.tagDecStep = this.getOutputTag("DecStep", res);
        this.tagMaxTmp = this.getOutputTag("MaxTmp", res);
        this.tagMinTmp = this.getOutputTag("MinTmp", res);
        this.tagAlmTHgh = this.getOutputTag("AlmTHigh", res);
        this.tagAlmTLow = this.getOutputTag("AlmTLow", res);
        this.tagAlmTDelta = this.getOutputTag("AlmTDelta", res);
        this.tagTimeOnInc = this.getOutputTag("TimeOnInc", res);
        this.tagTimeOnDec = this.getOutputTag("TimeOnDec", res);
        this.tagOldMaxTmp = this.getOutputTag("OldMaxTmp", res);
        this.tagTimeCnt = this.getOutputTag("TimeCnt", res);
        this.tagIncDecSost = this.getOutputTag("IncDecSost", res);
        this.commands.put(STEPPER_STATE_STOP, () -> this.tagOutVal.setInt(0));
        this.commands.put(STEPPER_STATE_START, () -> this.tagOutVal.setInt(0));
        super.prepareTags(res);
    }

    @Override
    public boolean execute() {
        if (this.inpEnable.getInt() == 1 && this.inpError.getInt() == 0) {
            if (this.isTemperatureOk()) {
                if (STEPPER_STATE_STOP == this.iState) {
                    this.iState = STEPPER_STATE_START;
                } else if (STEPPER_STATE_START == this.iState || STEPPER_STATE_WORK_DEC == this.iState) {
                    this.initCounters();
                    this.iState = STEPPER_STATE_WORK_INC;
                } else if (STEPPER_STATE_WORK_INC == this.iState) {
                    this.procsNormalHeating();
                }
            } else if (STEPPER_STATE_START == this.iState || STEPPER_STATE_WORK_INC == this.iState) {
                this.initCounters();
                this.fixOldMaxTemperature();
                this.iState = STEPPER_STATE_WORK_DEC;
            } else if (STEPPER_STATE_STOP != this.iState || STEPPER_STATE_ALM != this.iState) {
                if (this.isOverHeating()) {
                    this.iState = STEPPER_STATE_ALM;
                } else {
                    this.procsHighHeating();
                }
            }
        } else {
            this.iState = STEPPER_STATE_STOP;
        }
        this.tagState.setInt(this.iState);
        this.tagOutVal.setInt(this.iOutVal);
        this.tagOldMaxTmp.setInt(this.iOldMaxTmp);
        this.tagTimeCnt.setInt(this.iDwnCnt > this.iUpCnt ? this.iDwnCnt : this.iUpCnt);
        return true;
    }

    private void initCounters() {
        this.iDwnCnt = 0;
        this.iUpCnt = 0;
    }

    private boolean isTemperatureOk() {
        return this.inpCurTmp.getInt() < this.tagMaxTmp.getInt();
    }

    private boolean isOverHeating() {
        return this.inpCurTmp.getInt() >= this.iOldMaxTmp + this.tagAlmTDelta.getInt();
    }

    private void procsHighHeating() {
        if (this.iDwnCnt >= this.tagTimeOnDec.getInt()) {
            this.iDwnCnt = 0;
            if (this.iOutVal > 0) {
                this.iOutVal -= this.tagDecStep.getInt();
            }
            this.iOutVal = this.iOutVal <= 0 ? this.tagMinOut.getInt() : this.iOutVal;
        } else {
            ++this.iDwnCnt;
        }
    }

    private void procsNormalHeating() {
        if (this.iUpCnt >= this.tagTimeOnInc.getInt()) {
            this.iUpCnt = 0;
            if (this.iOutVal < this.tagMaxOut.getInt()) {
                this.iOutVal += this.tagIncStep.getInt();
            }
            this.iOutVal = this.iOutVal > this.tagMaxOut.getInt() ? this.tagMaxOut.getInt() : this.iOutVal;
        } else {
            ++this.iUpCnt;
        }
    }

    private void fixOldMaxTemperature() {
        this.iOldMaxTmp = this.inpCurTmp.getInt();
    }
}

