/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script.samples;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.plugin.script.ScriptJava;

public class DbWriterProbeScript
extends ScriptJava {
    private static final String TABLE = "MY_REPO";
    Database db1;
    Database db2;
    boolean connected;
    private boolean firstPass;
    private PreparedStatement pstInsert;
    private PreparedStatement pstDelete;

    @Override
    public boolean load() {
        this.firstPass = true;
        this.connected = false;
        return true;
    }

    @Override
    public void execute() {
        this.db1 = this.getDatabase("db1");
        this.db2 = this.getDatabase("db2");
        if (this.db1 == null || this.db2 == null) {
            this.printError("Database module is not found");
            return;
        }
        if (this.db1 == null || this.db2 == null || !this.isValid()) {
            return;
        }
        if (!this.connected && this.db1.isConnected() && this.db2.isConnected()) {
            this.connected = true;
        }
        if (!(!this.connected || this.db1.isConnected() && this.db2.isConnected())) {
            this.connected = false;
        }
        if (this.connected) {
            long t = System.currentTimeMillis();
            for (int i = 0; i < 10000; ++i) {
                try {
                    this.update();
                    continue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            System.out.println("" + (System.currentTimeMillis() - t));
        }
    }

    private void update() throws SQLException {
        if (this.firstPass) {
            this.createTable(this.db1);
            this.createTable(this.db2);
            this.initPst();
            this.firstPass = false;
        }
        String name = "my_tag_name";
        String val = System.currentTimeMillis() + "";
        try (Statement st = this.db1.getConnection().createStatement();){
            String sql = String.format("update or insert into %s (name, val) values ('%s', '%s')", TABLE, name, val);
            st.executeUpdate(sql);
        }
        catch (Exception e) {
            this.printError(e, "Request error 2");
        }
    }

    private void initPst() throws SQLException {
        String sql = String.format("delete from %s where name=?", TABLE);
        this.pstDelete = this.db1.getConnection().prepareStatement(sql);
        sql = String.format("insert into %s (name, val) values (?, ?)", TABLE);
        this.pstInsert = this.db1.getConnection().prepareStatement(sql);
    }

    private void createTable(Database db) {
        try (Statement st = db.getConnection().createStatement();){
            if (!db.hasTable(st, "", TABLE)) {
                String sql = String.format("create table %s (name varchar(128) not null primary key, val varchar(128) not null)", TABLE);
                st.executeUpdate(sql);
            }
            db.commit();
        }
        catch (SQLException e) {
            this.printError(e, "");
        }
    }
}

