/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.plugin.task.TaskItem;
import promauto.jroboplc.plugin.task.TaskModule;

public class TaskItemFlagWait
extends TaskItem {
    final Logger logger = LoggerFactory.getLogger(TaskItemFlagWait.class);
    protected int value;
    protected TaskModule targetTaskModule;
    private boolean timeoutEnabled;
    private boolean targetToItself;

    public TaskItemFlagWait(TaskModule parent, String args) {
        super(parent, args);
        String[] ss = args.split(",");
        if (ss.length == 2) {
            this.targetModuleName = ss[0];
            this.value = Integer.parseInt(ss[1].trim());
        } else if (ss.length == 1) {
            this.targetModuleName = this.parentModule.getName();
            this.value = Integer.parseInt(ss[0].trim());
        } else {
            this.targetModuleName = "";
        }
        this.timeoutEnabled = parent.period > 0;
        this.targetToItself = this.targetModuleName.equals(parent.getName());
    }

    @Override
    public boolean init() {
        if (super.init()) {
            if (this.targetModule.getClass() == TaskModule.class) {
                this.targetTaskModule = (TaskModule)this.targetModule;
                return true;
            }
            this.env.printError(this.logger, this.parentModule.getName(), "Module is not a task:", this.targetModuleName);
        }
        return false;
    }

    @Override
    public void execute(long maxTime) throws InterruptedException {
        if (this.targetTaskModule == null || this.parentModule == null) {
            return;
        }
        while (this.targetTaskModule.stateBaton != this.value && !this.parentModule.isStopped) {
            if (this.targetToItself) {
                if (this.targetTaskModule.stateBaton == -1) {
                    break;
                }
            } else if (this.timeoutEnabled && System.currentTimeMillis() - maxTime > 0L && this.targetTaskModule.stateBaton != -1) {
                this.targetTaskModule.stateBaton = -1;
                this.targetTaskModule.tagStatBaton.setInt(this.targetTaskModule.stateBaton);
            }
            Thread.sleep(1L);
        }
    }
}

