/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.DbHelper;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class CmdImport
extends AbstractCommand {
    private final Logger logger = LoggerFactory.getLogger(CmdImport.class);

    @Override
    public String getName() {
        return "import";
    }

    @Override
    public String getUsage() {
        return "db";
    }

    @Override
    public String getDescription() {
        return "imports wessvr data from database db";
    }

    @Override
    public String execute(Console console, Module module, String args) {
        module.postCommand(this, console, module, args);
        return "";
    }

    @Override
    public void executePosted(Console console, Module module, String args) {
        WessvrModule w = (WessvrModule)module;
        Database dbdst = w.getDatabase();
        if (!dbdst.isConnected()) {
            console.print("Database " + dbdst.getName() + " is not connected\n");
            return;
        }
        Module m = EnvironmentInst.get().getModuleManager().getModule(args);
        if (!(m instanceof Database)) {
            console.print("Module " + args + " is not a database\n");
            return;
        }
        Database dbsrc = (Database)m;
        if (!dbsrc.isConnected()) {
            console.print("Database " + dbsrc.getName() + " is not connected\n");
            return;
        }
        boolean hasModulesOutcalcmode = false;
        boolean hasMainIdbatch = false;
        try (Statement st = dbsrc.getConnection().createStatement();){
            hasModulesOutcalcmode = dbsrc.hasColumn(st, "", "modules", "outcalcmode");
            hasMainIdbatch = dbsrc.hasColumn(st, "", "main", "idbatch");
        }
        catch (SQLException e) {
            EnvironmentInst.get().printError(this.logger, e, new String[0]);
        }
        DbHelper.clear(console, dbdst, "arcidx, arcout, arcstatus, arcval, main, mainhr, stat, stathr, usermdl, userprev, userrep, usertrd, modules, producttags, brigada, extradatabases, previlegs, product, reports, trends, users, mgroup, mgroupmod, smenalist, smenas, modtypes ");
        DbHelper.copytbl(console, dbsrc, dbdst, "brigada", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "extradatabases", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "modtypes", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "previlegs", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "product", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "reports", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "smenalist", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "smenas", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "trends", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "users", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "modules", "IDM, IDMT, IDSL, NAME, DESCR, ENABLED, SVRNAME, ARCVALSIZE, ARCOUTSIZE, ARCOUTPER, ARCOUTTIME, WMUL, PROTOCOLVERSION, ARCSTATUS_OFF " + (hasModulesOutcalcmode ? ", OUTCALCMODE" : ""));
        DbHelper.copytbl(console, dbsrc, dbdst, "arcidx", "*", "idm", "modules");
        DbHelper.copytbl(console, dbsrc, dbdst, "arcout", "*", "idm", "modules");
        DbHelper.copytbl(console, dbsrc, dbdst, "arcstatus", "*", "idm", "modules");
        DbHelper.copytbl(console, dbsrc, dbdst, "arcval", "*", "idm", "modules");
        DbHelper.copytbl(console, dbsrc, dbdst, "mgroup", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "mgroupmod", "*", "idm", "modules");
        DbHelper.copytbl(console, dbsrc, dbdst, "producttags", "*", "idm", "modules");
        DbHelper.copytbl(console, dbsrc, dbdst, "usermdl", "*", "idm", "modules");
        DbHelper.copytbl(console, dbsrc, dbdst, "userprev", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "userrep", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "usertrd", "*");
        DbHelper.copytbl(console, dbsrc, dbdst, "main", "IDM, PERTYPE, DTBEG, WES, SWBEG, SWEND, WNUM, WNBEG, WNEND, OUTWES, OUTNUM, IDPROD, IDBRIG" + (hasMainIdbatch ? ", IDBATCH" : ""));
        DbHelper.copytbl(console, dbsrc, dbdst, "mainhr", "IDM, PERTYPE, DTBEG, WES, SWBEG, SWEND, WNUM, WNBEG, WNEND, OUTWES, OUTNUM, IDPROD, IDBRIG" + (hasMainIdbatch ? ", IDBATCH" : ""));
        DbHelper.copytbl(console, dbsrc, dbdst, "stat", "IDR, IDM, PERTYPE, PERIOD, DTBEG, DTEND, WES, SWBEG, SWEND, WNUM, WNBEG, WNEND, OUTWES, OUTNUM, IDPROD, IDBRIG" + (hasMainIdbatch ? ", IDBATCH" : ""));
        DbHelper.copytbl(console, dbsrc, dbdst, "stathr", "IDR, IDM, PERTYPE, PERIOD, DTBEG, DTEND, WES, SWBEG, SWEND, WNUM, WNBEG, WNEND, OUTWES, OUTNUM, IDPROD, IDBRIG" + (hasMainIdbatch ? ", IDBATCH" : ""));
        DbHelper.copygen(console, dbdst, "modules", "gen_modules_id", "idm");
        DbHelper.copygen(console, dbdst, "brigada", "gen_brigada_id", "idbrig");
        DbHelper.copygen(console, dbdst, "extradatabases", "gen_extradatabases_id", "id");
        DbHelper.copygen(console, dbdst, "modtypes", "gen_modtypes_id", "idmt");
        DbHelper.copygen(console, dbdst, "product", "gen_product_id", "idprod");
        DbHelper.copygen(console, dbdst, "reports", "gen_reports_id", "idrep");
        DbHelper.copygen(console, dbdst, "smenalist", "gen_smenalist_id", "idsl");
        DbHelper.copygen(console, dbdst, "smenas", "gen_smenas_id", "idsmena");
        DbHelper.copygen(console, dbdst, "trends", "gen_trends_id", "idtrd");
        DbHelper.copygen(console, dbdst, "users", "gen_users_id", "iduser");
        DbHelper.copygen(console, dbdst, "mgroup", "gen_mgroup_id", "idgroup");
        DbHelper.copygen(console, dbdst, "producttags", "gen_producttags_id", "id");
        DbHelper.copygen(console, dbdst, "stat", "gen_stat_id", "idr");
        DbHelper.copygen(console, dbdst, "stathr", "gen_stathr_id", "idr");
        console.print("Done\n");
    }
}

