/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class DeviceAkkont
extends DeviceBase {
    public static final String MODTYPE = "Akkont 908";
    protected RefItem refCrc;
    protected RefItem refSumWesHigh;
    protected RefItem refSumWesLow;
    protected RefItem refWNum;
    protected RefItem refLastWes;
    protected RefItem refCurWes;
    protected RefItem refStageNum;
    protected RefItem refWCycle;
    protected RefItem refOutput;

    public DeviceAkkont(WessvrModule module) {
        super(module);
        this.sizeSumWeight = 4000000000L;
        this.sizeSumNum = 65536L;
    }

    @Override
    public String getModtype() {
        return MODTYPE;
    }

    @Override
    protected void createRefs() {
        super.createRefs();
        this.refCrc = this.refs.createItemCrcSum(this.name, "Crc16");
        this.refSumWesHigh = this.refs.createItemCrc(this.name, "SumWesHigh");
        this.addVldZero(this.addVldFFFF(this.refSumWesHigh));
        this.refSumWesLow = this.refs.createItemCrc(this.name, "SumWesLow");
        this.addVldZero(this.addVldFFFF(this.refSumWesLow));
        this.refWNum = this.refs.createItemCrc(this.name, "WNum");
        this.addVldZero(this.addVldFFFF(this.refWNum));
        this.refLastWes = this.refs.createItemCrc(this.name, "LastWes");
        this.addVldZero(this.addVldFFFF(this.refLastWes));
        this.refs.addItemCrc(this.refErrorFlag);
        this.refCurWes = this.refs.createItem(this.name, "CurWes");
        this.refStageNum = this.refs.createItem(this.name, "StageNum");
        this.refWCycle = this.refs.createItem(this.name, "WCycle");
        this.refOutput = this.refs.createItem(this.name, "Output");
    }

    @Override
    protected long getSumWeight() {
        return ((long)this.refSumWesHigh.getValue().getInt() << 16) + (long)this.refSumWesLow.getValue().getInt();
    }

    @Override
    protected long getSumNum() {
        return this.refWNum.getValue().getInt();
    }

    @Override
    protected boolean updateValuesStatus() {
        if (!this.hasStatusValuesChanged(null, this.refStageNum)) {
            return false;
        }
        this.statusValues[1] = this.refStageNum.getValue().getInt();
        return true;
    }

    @Override
    protected boolean updateValuesArcval() {
        if (this.arcvalValues[0] == this.getSumWeight() && this.arcvalValues[1] == this.getSumNum()) {
            return false;
        }
        this.arcvalValues[0] = this.getSumWeight();
        this.arcvalValues[1] = this.getSumNum();
        this.arcvalValues[2] = this.refLastWes.getValue().getInt();
        this.arcvalValues[3] = this.refWCycle.getValue().getInt();
        this.arcvalValues[4] = this.refStageNum.getValue().getInt();
        return true;
    }

    @Override
    protected double getArcoutValue() {
        return this.refOutput.getValue().getDouble();
    }
}

