/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.SQLException;
import promauto.jroboplc.plugin.wessvr.DeviceAkkont;
import promauto.jroboplc.plugin.wessvr.DeviceAtara;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.DeviceCentaURZ;
import promauto.jroboplc.plugin.wessvr.DeviceGelios;
import promauto.jroboplc.plugin.wessvr.DeviceGeliosMaslo2v2;
import promauto.jroboplc.plugin.wessvr.DeviceMercuryECnt;
import promauto.jroboplc.plugin.wessvr.DeviceStandard;
import promauto.jroboplc.plugin.wessvr.DeviceTenzomTb09;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class DeviceFactory {
    public static DeviceBase create(WessvrModule module, String modtype) throws SQLException {
        switch (modtype.toLowerCase()) {
            case "standard": {
                return new DeviceStandard(module);
            }
            case "gelios": {
                return new DeviceGelios(module);
            }
            case "gelios.maslo2v2": {
                return new DeviceGeliosMaslo2v2(module);
            }
            case "akkont 908": {
                return new DeviceAkkont(module);
            }
            case "atara": {
                return new DeviceAtara(module);
            }
            case "mercury": {
                return new DeviceMercuryECnt(module);
            }
            case "tenzom_tb009": {
                return new DeviceTenzomTb09(module);
            }
            case "centaurz": {
                return new DeviceCentaURZ(module);
            }
        }
        return null;
    }
}

