/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class DeviceMercuryECnt
extends DeviceBase {
    private final Logger logger = LoggerFactory.getLogger(DeviceMercuryECnt.class);
    public static final String MODTYPE = "MercuryECnt";
    protected RefItem refCrc;
    protected RefItem refPSumAfterResetH;
    protected RefItem refPSumAfterResetL;
    protected RefItem refSerialNumberH;
    protected RefItem refSerialNumberL;

    public DeviceMercuryECnt(WessvrModule module) {
        super(module);
        this.sizeSumWeight = 0x100000000L;
        this.sizeSumNum = 0x100000000L;
    }

    @Override
    public String getModtype() {
        return MODTYPE;
    }

    @Override
    protected void createRefs() {
        super.createRefs();
        this.refCrc = this.refs.createItemCrcSum(this.name, "Crc16");
        this.refSerialNumberH = this.refs.createItemCrc(this.name, "SerialNumberH");
        this.addVldZero(this.addVldFFFF(this.refSerialNumberH));
        this.refSerialNumberL = this.refs.createItemCrc(this.name, "SerialNumberL");
        this.addVldZero(this.addVldFFFF(this.refSerialNumberL));
        this.refPSumAfterResetH = this.refs.createItemCrc(this.name, "PSumAfterResetH");
        this.addVldZero(this.addVldFFFF(this.refPSumAfterResetH));
        this.refPSumAfterResetL = this.refs.createItemCrc(this.name, "PSumAfterResetL");
        this.addVldZero(this.addVldFFFF(this.refPSumAfterResetL));
        this.refs.addItemCrc(this.refErrorFlag);
    }

    @Override
    protected long getSumWeight() {
        return ((long)this.refPSumAfterResetH.getValue().getInt() << 16) + (long)this.refPSumAfterResetL.getValue().getInt();
    }

    @Override
    protected long getSumNum() {
        return ((long)this.refSerialNumberH.getValue().getInt() << 16) + (long)this.refSerialNumberL.getValue().getInt();
    }

    @Override
    protected boolean updateValuesStatus() {
        return true;
    }

    @Override
    protected boolean updateValuesArcval() {
        if (this.arcvalValues[0] == this.getSumWeight()) {
            return false;
        }
        this.arcvalValues[0] = this.getSumWeight();
        this.arcvalValues[1] = this.getSumNum();
        return true;
    }

    @Override
    protected double getArcoutValue() {
        return ((long)this.refPSumAfterResetH.getValue().getInt() << 16) + (long)this.refPSumAfterResetL.getValue().getInt();
    }
}

