/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class DeviceTenzomTb09
extends DeviceBase {
    public static final String MODTYPE = "TenzoM_TB009";
    protected RefItem refSumWeightHigh;
    protected RefItem refSumWeightLow;
    protected RefItem refSumNumHigh;
    protected RefItem refSumNumLow;
    protected RefItem refLastWeightHigh;
    protected RefItem refLastWeightLow;
    protected RefItem refLastTimeHigh;
    protected RefItem refLastTimeLow;
    protected RefItem refOutputHigh;
    protected RefItem refOutputLow;
    protected RefItem refVersion;
    int version;

    public DeviceTenzomTb09(WessvrModule module) {
        super(module);
        this.sizeSumWeight = 0x100000000L;
        this.sizeSumNum = 0x100000000L;
        this.version = 0;
    }

    @Override
    public String getModtype() {
        return MODTYPE;
    }

    @Override
    protected void createRefs() {
        super.createRefs();
        this.refSumWeightHigh = this.refs.createItemCrc(this.name, "SumWeightHigh");
        this.addVldZero(this.addVldFFFF(this.refSumWeightHigh));
        this.refSumWeightLow = this.refs.createItemCrc(this.name, "SumWeightLow");
        this.addVldZero(this.addVldFFFF(this.refSumWeightLow));
        this.refSumNumHigh = this.refs.createItemCrc(this.name, "SumNumHigh");
        this.addVldZero(this.addVldFFFF(this.refSumNumHigh));
        this.refSumNumLow = this.refs.createItemCrc(this.name, "SumNumLow");
        this.addVldZero(this.addVldFFFF(this.refSumNumLow));
        this.refLastWeightHigh = this.refs.createItemCrc(this.name, "LastWeightHigh");
        this.addVldZero(this.addVldFFFF(this.refLastWeightHigh));
        this.refLastWeightLow = this.refs.createItemCrc(this.name, "LastWeightLow");
        this.addVldZero(this.addVldFFFF(this.refLastWeightLow));
        this.refLastTimeHigh = this.refs.createItemCrc(this.name, "LastTimeHigh");
        this.addVldZero(this.addVldFFFF(this.refLastTimeHigh));
        this.refLastTimeLow = this.refs.createItemCrc(this.name, "LastTimeLow");
        this.addVldZero(this.addVldFFFF(this.refLastTimeLow));
        this.refOutputHigh = this.refs.createItemCrc(this.name, "OutputHigh");
        this.addVldZero(this.addVldFFFF(this.refOutputHigh));
        this.refOutputLow = this.refs.createItemCrc(this.name, "OutputLow");
        this.addVldZero(this.addVldFFFF(this.refOutputLow));
        this.refs.addItemCrc(this.refErrorFlag);
        this.refVersion = this.refs.createItemCrc(this.name, "Version");
    }

    @Override
    protected long getSumWeight() {
        return ((long)this.refSumWeightHigh.getValue().getInt() << 16) + (long)this.refSumWeightLow.getValue().getInt();
    }

    @Override
    protected long getSumNum() {
        return ((long)this.refSumNumHigh.getValue().getInt() << 16) + (long)this.refSumNumLow.getValue().getInt();
    }

    @Override
    protected boolean updateValuesArcval() {
        if (this.arcvalValues[0] == this.getSumWeight() && this.arcvalValues[1] == this.getSumNum()) {
            return false;
        }
        this.arcvalValues[0] = this.getSumWeight();
        this.arcvalValues[1] = this.getSumNum();
        this.arcvalValues[2] = ((long)this.refLastWeightHigh.getValue().getInt() << 16) + (long)this.refLastWeightLow.getValue().getInt();
        this.arcvalValues[3] = ((long)this.refLastTimeHigh.getValue().getInt() << 16) + (long)this.refLastTimeLow.getValue().getInt();
        this.arcvalValues[4] = 0L;
        return true;
    }

    @Override
    protected double getArcoutValue() {
        return (this.refOutputHigh.getValue().getInt() << 16) + this.refOutputLow.getValue().getInt();
    }

    @Override
    protected void doAfterRefsRead() {
        if (this.refVersion.getValue().getInt() == 1) {
            this.sizeSumWeight = 1000000000L;
            this.sizeSumNum = 1000000000L;
        } else {
            this.sizeSumWeight = 0x100000000L;
            this.sizeSumNum = 0x100000000L;
        }
    }
}

