/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.util.HashMap;
import java.util.Map;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.utils.Strings;

public abstract class AbstractConsole
implements Console {
    protected Environment env;
    protected Map<String, String> props = new HashMap<String, String>();
    private String lastRequest = "";
    private volatile boolean repeatingLastRequest = false;
    private Thread threadRepeat = null;

    public AbstractConsole(Environment envinronment) {
        this.env = envinronment;
    }

    @Override
    public String getPrompt() {
        if (this.env.isRunning()) {
            return "run>";
        }
        return "idle>";
    }

    @Override
    public String getProperty(String property_id, String default_value) {
        return this.props.getOrDefault(property_id, default_value);
    }

    @Override
    public void setProperty(String property_id, String value) {
        this.props.put(property_id, value);
    }

    @Override
    public int getProperty(String property_id, int default_value) {
        try {
            if (this.props.containsKey(property_id)) {
                return Integer.parseInt(this.props.get(property_id));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return default_value;
    }

    @Override
    public String parseAnsi(String text) {
        if (this.getProperty("ansi", "off").equals("on")) {
            return text;
        }
        return Strings.removeAnsiColors(text);
    }

    protected void afterRequestExecuted(String request) {
        if (this.repeatingLastRequest && request.isEmpty()) {
            this.stopRepeatingLastRequest();
        }
        if (!this.repeatingLastRequest && !request.isEmpty()) {
            this.lastRequest = request;
        }
    }

    @Override
    public synchronized String startRepeatingLastRequest(long updatePeriod) {
        if (this.repeatingLastRequest) {
            return "";
        }
        if (this.lastRequest.isEmpty()) {
            return "Nothing to repeat\r\n";
        }
        this.repeatingLastRequest = true;
        long period = updatePeriod <= 0L ? 1000L : updatePeriod;
        Runnable task = () -> {
            boolean i = false;
            while (this.repeatingLastRequest && EnvironmentInst.get().isRunning()) {
                String s = "\u001b[2J\u001b[H" + this.env.getCmdDispatcher().execute(this, this.lastRequest) + "\r\nPress ENTER to return";
                this.print(s);
                try {
                    Thread.sleep(period);
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        this.threadRepeat = new Thread(task);
        this.threadRepeat.start();
        return "";
    }

    @Override
    public synchronized void stopRepeatingLastRequest() {
        if (!this.repeatingLastRequest) {
            return;
        }
        this.repeatingLastRequest = false;
        this.threadRepeat.interrupt();
    }
}

