/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.KeyManager;

public class KeyManagerImpl
implements KeyManager {
    private final Logger logger = LoggerFactory.getLogger(KeyManagerImpl.class);
    public static final String PUBLIC_EXTENSION = ".pub";
    private final Path keysDir;
    private final Map<String, Key> keys = new HashMap<String, Key>();

    public KeyManagerImpl() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.keysDir = cm.getPath(cm.getRoot(), "keys.dir", "keys");
    }

    @Override
    public String encryptPublic(String keyName, String decryptedText) throws Exception {
        RSAPublicKey publicKey = this.readPublicKey(keyName);
        Cipher encryptCipher = Cipher.getInstance("RSA");
        encryptCipher.init(1, publicKey);
        byte[] encryptedTextBytes = encryptCipher.doFinal(decryptedText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encryptedTextBytes);
    }

    @Override
    public String decryptPrivate(String keyName, String enryptedText) throws Exception {
        RSAPrivateKey privateKey = this.readPrivateKey(keyName);
        Cipher decryptCipher = Cipher.getInstance("RSA");
        decryptCipher.init(2, privateKey);
        byte[] encryptedTextBytes = Base64.getDecoder().decode(enryptedText);
        byte[] decryptedTextBytes = decryptCipher.doFinal(encryptedTextBytes);
        return new String(decryptedTextBytes, StandardCharsets.UTF_8);
    }

    @Override
    public String generateAndSaveKeyPair(String keyName) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024);
            KeyPair kp = generator.generateKeyPair();
            String privateKeyText = "-----BEGIN PRIVATE KEY-----\r\n" + Base64.getMimeEncoder().encodeToString(kp.getPrivate().getEncoded()) + "\r\n-----END PRIVATE KEY-----";
            String publicKeyText = "-----BEGIN PUBLIC KEY-----\r\n" + Base64.getMimeEncoder().encodeToString(kp.getPublic().getEncoded()) + "\r\n-----END PUBLIC KEY-----";
            if (keyName.isEmpty()) {
                while (Files.exists(this.keysDir.resolve(keyName = "key" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"))), new LinkOption[0]) || Files.exists(this.keysDir.resolve(keyName + PUBLIC_EXTENSION), new LinkOption[0])) {
                }
            }
            Files.createDirectories(this.keysDir, new FileAttribute[0]);
            Files.write(this.keysDir.resolve(keyName), privateKeyText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(this.keysDir.resolve(keyName + PUBLIC_EXTENSION), publicKeyText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, "Failed to generate keys: " + keyName);
        }
        return keyName;
    }

    @Override
    public String getDefaultPrivateKeyName() {
        try {
            List found = Files.find(this.keysDir, 1, (path, attr) -> !path.toString().endsWith(PUBLIC_EXTENSION) && attr.isRegularFile(), new FileVisitOption[0]).collect(Collectors.toList());
            if (found.size() == 1) {
                return ((Path)found.get(0)).getFileName().toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    private RSAPublicKey readPublicKey(String keyName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private RSAPrivateKey readPrivateKey(String keyName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

