/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.util.HashMap;
import promauto.jroboplc.core.api.Tag;

public class State
extends HashMap<String, String> {
    private String varprefix = "";

    public void setVarPrefix(String prefix) {
        this.varprefix = prefix;
    }

    public void loadTag(Tag tag) {
        String value = (String)this.get(tag.getName());
        if (value != null) {
            tag.setString(value);
        }
    }

    public void saveTag(Tag tag) {
        this.put(tag.getName(), tag.getString());
    }

    public boolean loadVar(String key, boolean defvalue) {
        String value = (String)this.get(this.varprefix + key);
        if (value != null) {
            return value.equals("on");
        }
        return defvalue;
    }

    public int loadVar(String key, int defvalue) {
        String value = (String)this.get(this.varprefix + key);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defvalue;
    }

    public long loadVar(String key, long defvalue) {
        String value = (String)this.get(this.varprefix + key);
        try {
            if (value != null) {
                return Long.parseLong(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defvalue;
    }

    public double loadVar(String key, double defvalue) {
        String value = (String)this.get(this.varprefix + key);
        try {
            if (value != null) {
                return Double.parseDouble(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defvalue;
    }

    public String loadVar(String key, String defvalue) {
        String value = (String)this.get(this.varprefix + key);
        if (value != null) {
            return value;
        }
        return defvalue;
    }

    public void saveVar(String key, boolean value) {
        this.put(this.varprefix + key, value ? "on" : "off");
    }

    public void saveVar(String key, int value) {
        this.put(this.varprefix + key, "" + value);
    }

    public void saveVar(String key, long value) {
        this.put(this.varprefix + key, "" + value);
    }

    public void saveVar(String key, double value) {
        this.put(this.varprefix + key, "" + value);
    }

    public void saveVar(String key, String value) {
        this.put(this.varprefix + key, value);
    }

    public boolean hasVar(String key) {
        return this.containsKey(this.varprefix + key);
    }
}

