/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBase;

public class TagBool
extends TagBase {
    private volatile boolean value = false;

    public TagBool(String name, boolean value) {
        super(name);
        this.setBool(value);
    }

    public TagBool(String name, boolean value, int flags) {
        super(name, flags);
        this.setBool(value);
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.BOOL;
    }

    @Override
    public boolean getBool() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value ? 1 : 0;
    }

    @Override
    public long getLong() {
        return this.value ? 1L : 0L;
    }

    @Override
    public double getDouble() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public String getString() {
        return this.value ? "on" : "off";
    }

    @Override
    public void setBool(boolean value) {
        if (this.value != value) {
            this.value = value;
        }
    }

    @Override
    public void setOn() {
        if (!this.value) {
            this.value = true;
        }
    }

    @Override
    public void setOff() {
        if (this.value) {
            this.value = false;
        }
    }

    @Override
    public void setInt(int value) {
        if (this.value != (value != 0)) {
            this.value = value != 0;
        }
    }

    @Override
    public void setLong(long value) {
        if (this.value != (value != 0L)) {
            this.value = value != 0L;
        }
    }

    @Override
    public void setDouble(double value) {
        if (this.value != (value != 0.0)) {
            this.value = value != 0.0;
        }
    }

    @Override
    public void setString(String value) {
        boolean parsed = value.equals("on");
        if (this.value != parsed) {
            this.value = parsed;
        }
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getBool() == this.value;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setBool(this.value);
    }
}

