/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkmansvr;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.kkmansvr.Doser;
import promauto.jroboplc.plugin.kkmansvr.Line;

public class Component {
    private static final int COMP_IDLE = 0;
    private static final int COMP_PREPARING = 1;
    private static final int COMP_LOADING = 2;
    private static final int COMP_FINISHED = 3;
    public static final String NOT_FOUND = "NOT FOUND";
    final List<Tag> repoTags = new ArrayList<Tag>();
    public final Line line;
    public final int num;
    private TagRW tagDoserId;
    private TagRW tagDoserName;
    private TagRW tagDoserDescr;
    private TagRW tagManual;
    private TagRW tagProdId;
    private TagRW tagProdName;
    private TagRW tagWeightReq;
    private TagRW tagWeightFin;
    private TagRW tagWeightCur;
    private TagRW tagStatus;
    private TagRW tagRun;
    private TagRW tagCancel;

    public Component(Line line, int num) {
        this.line = line;
        this.num = num;
    }

    public void loadTags(TagTable tt) {
        this.repoTags.clear();
        String name = "Comp" + this.num;
        this.tagCancel = tt.createRWBool(name + ".Cancel", false);
        this.tagWeightCur = tt.createRWInt(name + ".WeightCur", 0);
        this.tagDoserId = tt.createRWInt(name + ".DoserId", 0);
        this.repoTags.add(this.tagDoserId);
        this.tagDoserName = tt.createRWString(name + ".DoserName", "");
        this.repoTags.add(this.tagDoserName);
        this.tagDoserDescr = tt.createRWString(name + ".DoserDescr", "");
        this.repoTags.add(this.tagDoserDescr);
        this.tagManual = tt.createRWBool(name + ".Manual", false);
        this.repoTags.add(this.tagManual);
        this.tagProdId = tt.createRWInt(name + ".ProdId", 0);
        this.repoTags.add(this.tagProdId);
        this.tagProdName = tt.createRWString(name + ".ProdName", "");
        this.repoTags.add(this.tagProdName);
        this.tagWeightReq = tt.createRWInt(name + ".WeightReq", 0);
        this.repoTags.add(this.tagWeightReq);
        this.tagWeightFin = tt.createRWInt(name + ".WeightFin", 0);
        this.repoTags.add(this.tagWeightFin);
        this.tagStatus = tt.createRWInt(name + ".Status", 0);
        this.repoTags.add(this.tagStatus);
        this.tagRun = tt.createRWBool(name + ".Run", false);
        this.repoTags.add(this.tagRun);
    }

    public void execute() {
        if (this.tagCancel.hasWriteValue() && this.tagCancel.getWriteValBool()) {
            this.setStatus(0);
            this.tagRun.setReadValBool(false);
        }
        if (this.tagRun.hasWriteValue() && this.tagRun.getWriteValBool() && this.isStatus(0)) {
            boolean hasRunning = this.line.comps.stream().filter(comp -> comp.tagDoserId.getInt() == this.tagDoserId.getInt()).anyMatch(comp -> comp.tagRun.getBool());
            if (this.isComponentInUse() && this.line.isStatus(2) && !hasRunning) {
                this.tagRun.setReadValBool(true);
                this.setStatus(1);
            }
        }
        if (this.isStatus(1) && this.doCompPreparing()) {
            this.setStatus(2);
        }
        if (this.isStatus(2) && this.doCompLoading()) {
            this.setStatus(3);
        }
        if (this.isStatus(3)) {
            // empty if block
        }
    }

    private boolean isStatus(int status) {
        return this.tagStatus.getInt() == status;
    }

    private void setStatus(int status) {
        this.tagStatus.setReadValInt(status);
    }

    public void updateDoserTags() {
        if (this.tagDoserId.getInt() == 0) {
            this.tagDoserName.setReadValString("");
            this.tagDoserDescr.setReadValString("");
            this.tagManual.setReadValBool(false);
            this.tagWeightCur.setReadValInt(0);
        } else {
            Doser doser = this.line.getDoser(this.tagDoserId);
            if (doser == null) {
                this.tagDoserName.setReadValString(NOT_FOUND);
                this.tagDoserDescr.setReadValString(NOT_FOUND);
                this.tagManual.setReadValBool(false);
                this.tagWeightCur.setReadValInt(0);
            } else {
                this.tagDoserName.setReadValString(doser.getName());
                this.tagDoserDescr.setReadValString(doser.getDescr());
                this.tagManual.setReadValBool(doser.isManual());
                this.tagWeightCur.setReadValInt(doser.getWeightCur());
            }
        }
    }

    public void resetTask() {
        this.tagDoserId.setReadValInt(0);
        this.tagDoserName.setReadValString("");
        this.tagDoserDescr.setReadValString("");
        this.tagProdId.setReadValInt(0);
        this.tagProdName.setReadValString("");
        this.tagWeightReq.setReadValInt(0);
        this.resetCycle();
    }

    public void resetCycle() {
        this.tagStatus.setReadValInt(0);
        this.tagRun.setReadValInt(0);
        this.tagWeightFin.setReadValInt(0);
    }

    public int getWeightReq() {
        return this.tagWeightReq.getInt();
    }

    public int getWeightFin() {
        return this.tagWeightFin.getInt();
    }

    public boolean isFinished() {
        return this.tagStatus.getInt() == 3;
    }

    public boolean isComponentInUse() {
        return this.tagWeightReq.getInt() > 0;
    }

    private boolean withDoserInUse(Function<Doser, Boolean> action) {
        if (!this.isComponentInUse()) {
            return true;
        }
        Doser doser = this.line.getDoser(this.tagDoserId);
        if (doser == null || !doser.isConnected()) {
            return false;
        }
        return action.apply(doser);
    }

    private boolean doCompPreparing() {
        return this.withDoserInUse(doser -> {
            doser.setWeightReq(this.tagWeightReq.getInt());
            doser.setEmptyCur(true);
            doser.setRun(false);
            if (doser.isEmptyCur() && doser.isStatusStop()) {
                doser.setRun(true);
                return true;
            }
            return false;
        });
    }

    private boolean doCompLoading() {
        return this.withDoserInUse(doser -> {
            doser.setWeightReq(this.tagWeightReq.getInt());
            doser.setRun(true);
            if (doser.isFinished()) {
                this.tagRun.setReadValBool(false);
                doser.setRun(false);
                this.tagWeightFin.setReadValInt(doser.getWeightCur());
                return true;
            }
            return false;
        });
    }

    public void setProductId(int value) {
        this.tagProdId.setReadValInt(value);
    }

    public void setProductName(String value) {
        this.tagProdName.setReadValString(value);
    }

    public void setDoserId(int value) {
        this.tagDoserId.setReadValInt(value);
    }

    public void setWeightReq(int value) {
        this.tagWeightReq.setReadValInt(value);
    }

    public int getProductId() {
        return this.tagProdId.getInt();
    }
}

