/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.Context;
import promauto.jroboplc.plugin.motohr.Counter;
import promauto.jroboplc.plugin.motohr.CounterType;
import promauto.jroboplc.plugin.motohr.MachState;

public class Mach {
    public static Map<Integer, String> cacheDescrs;
    private int id;
    private final Context ctx;
    public final Tag tag;
    public final String tagname;
    public final String name;
    public MachState state;
    public List<Counter> counters;
    private Counter counterTotal;
    public final TagRW tagDescr;
    public final TagRW tagTime;

    public Mach(Context ctx, Tag tag, String tagname, String name, String descr) {
        this.ctx = ctx;
        this.tag = tag;
        this.tagname = tagname;
        this.name = name;
        this.state = null;
        this.tagDescr = ctx.tagtable.createRWString(name + ".descr", descr);
        this.tagTime = ctx.tagtable.createRWLong(name + ".time", 0L);
        this.counters = new LinkedList<Counter>();
    }

    public int getId() {
        return this.id;
    }

    public Counter getCounterTotal() {
        return this.counterTotal;
    }

    public void init() throws SQLException {
        this.id = this.ctx.service.syncMach(this.tagname, this.name, this.tagDescr.getString());
        if (this.tagDescr.getString().isEmpty() && cacheDescrs.containsKey(this.id)) {
            this.tagDescr.setReadValString(cacheDescrs.get(this.id));
        }
        this.state = MachState.cache.get(this.id);
        if (this.state == null) {
            this.state = new MachState(this.ctx.now(), this.tag.getBool(), 0, 0);
            this.ctx.service.saveMachState(this.id, this.state);
        }
        this.updateTime();
        this.counters.clear();
        for (Counter.DTO dto : this.ctx.service.loadCounters(this.id)) {
            CounterType ct = this.ctx.counterTypes.get(dto.counterTypeId);
            if (ct == null) continue;
            this.counters.add(new Counter(this.ctx, dto.id, ct, this, dto.sec));
        }
        Optional<Counter> found = this.counters.stream().filter(cnt -> cnt.counterType.id == 1).findFirst();
        if (found.isPresent()) {
            this.counterTotal = found.get();
        } else {
            CounterType ctTotal = this.ctx.counterTypes.get(1);
            if (this.counters.stream().noneMatch(cnt -> cnt.counterType == ctTotal)) {
                int counterTotalId = this.ctx.service.createCounter(this.id, 1);
                this.counterTotal = new Counter(this.ctx, counterTotalId, ctTotal, this, 0);
                this.counters.add(this.counterTotal);
            }
        }
    }

    public static void executeAll(Context ctx) throws SQLException {
        for (Mach mach : ctx.machs) {
            mach.execute();
        }
    }

    public void execute() throws SQLException {
        if (this.tag.getStatus() == Tag.Status.Deleted) {
            this.ctx.module.raiseNeedInit();
            return;
        }
        if (this.tag.getBool() != this.state.running) {
            LocalDateTime dtnow = this.ctx.now();
            this.state.running = this.tag.getBool();
            if (this.state.running) {
                ++this.state.statcnt;
            } else {
                int sec = (int)ChronoUnit.SECONDS.between(this.state.dt, dtnow);
                this.ctx.service.saveInterval(this.id, this.state.dt, dtnow, sec);
                for (Counter counter : this.counters) {
                    counter.addSeconds(sec);
                }
            }
            this.state.dt = dtnow;
            this.ctx.service.saveMachState(this.id, this.state);
            this.updateTime();
        }
        for (Counter counter : this.counters) {
            counter.execute();
        }
        if (this.tagDescr.hasWriteValue()) {
            this.tagDescr.copyLastWriteToRead();
            this.ctx.service.syncMach(this.tagname, this.name, this.tagDescr.getString());
        }
    }

    private void updateTime() {
        if (this.state.running) {
            this.tagTime.setReadValLong(this.ctx.convertTime(this.state.dt));
        } else {
            this.tagTime.setReadValLong(0L);
        }
    }

    public void saveStat(int period) throws SQLException {
        if (this.counterTotal == null) {
            return;
        }
        int totalsec = this.counterTotal.getValue();
        if (period > 0) {
            int statsec = totalsec - this.state.statsec;
            this.ctx.service.saveStat(this.id, period, this.state.statcnt, statsec);
        }
        this.state.statcnt = 0;
        this.state.statsec = totalsec;
        this.ctx.service.saveMachState(this.id, this.state);
    }

    public int getRunningSec() {
        if (this.state.running) {
            return (int)(this.ctx.tagTime.getLong() - this.tagTime.getLong());
        }
        return 0;
    }

    public void remove() {
        this.ctx.tagtable.remove(this.tagDescr);
        this.ctx.tagtable.remove(this.tagTime);
        this.counters.forEach(Counter::remove);
    }
}

