/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolIcpcon;
import promauto.utils.Numbers;

public class I7017Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(I7017Module.class);
    protected ProtocolIcpcon protocol = new ProtocolIcpcon(this);
    private static final int INP_SIZE = 8;
    private static final int ANSWER_SIZE = 36;
    protected Tag tagTypeCode;
    protected Input[] inputs = new Input[8];
    protected boolean nominus = false;
    protected boolean noscale = false;
    private int[] buffout = new int[16];
    private int[] buffin = new int[48];

    public I7017Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.nominus = cm.get(conf, "nominus", false);
        this.noscale = cm.get(conf, "noscale", false);
        this.initTags();
        return true;
    }

    protected void initTags() {
        for (int i = 0; i < 8; ++i) {
            String inp = "inp" + i + ".";
            this.inputs[i] = new Input();
            this.inputs[i].value = this.tagtable.createInt(inp + "value", 0, 8);
            if (this.noscale) continue;
            this.inputs[i].scaled = this.tagtable.createDouble(inp + "scaled", 0.0, 8);
            this.inputs[i].v1 = this.tagtable.createInt(inp + "v1", 0, 1);
            this.inputs[i].s1 = this.tagtable.createDouble(inp + "s1", 0.0, 1);
            this.inputs[i].v2 = this.tagtable.createInt(inp + "v2", 0, 1);
            this.inputs[i].s2 = this.tagtable.createDouble(inp + "s2", 0.0, 1);
        }
        this.tagTypeCode = this.tagtable.createInt("TypeCode", 0, 8);
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < 8; ++i) {
            this.addChannelMapTag(chtags, this.inputs[i].value, "" + i);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = false;
        try {
            int n;
            if (this.firstPass || this.tagError.getBool()) {
                this.buffout[0] = 36;
                this.buffout[3] = 50;
                n = this.protocol.request(this.buffout, 4, this.buffin, 12);
                if (n == 12) {
                    this.tagTypeCode.setInt((short)Numbers.asciiByteToInt(this.buffin, 3));
                }
            }
            this.buffout[0] = 35;
            n = this.protocol.request(this.buffout, 3, this.buffin, 36);
            if (n == 36) {
                int idx = 1;
                for (int i = 0; i < 8; ++i) {
                    short value = (short)Numbers.asciiWordToInt(this.buffin, idx);
                    if (!this.noscale) {
                        double v1 = this.inputs[i].v1.getInt();
                        double s1 = this.inputs[i].s1.getDouble();
                        double vsub = (double)this.inputs[i].v2.getInt() - v1;
                        double ssub = this.inputs[i].s2.getDouble() - s1;
                        if (this.inputs[i].v2.getInt() - this.inputs[i].v1.getInt() > 0) {
                            double scaled = ((double)value - v1) * ssub / vsub + s1;
                            this.inputs[i].scaled.setDouble(scaled);
                        } else {
                            this.inputs[i].scaled.setDouble(0.0);
                        }
                    }
                    if (this.nominus && value < 0) {
                        value = 0;
                    }
                    this.inputs[i].value.setInt(value);
                    idx += 4;
                }
                result = true;
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    @Override
    protected boolean reload() {
        I7017Module tmp = new I7017Module(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        for (int i = 0; i < 8; ++i) {
            if (this.noscale && !tmp.noscale) {
                this.inputs[i].scaled = tmp.inputs[i].scaled;
                this.tagtable.add(this.inputs[i].scaled);
                this.inputs[i].v1 = tmp.inputs[i].v1;
                this.tagtable.add(this.inputs[i].v1);
                this.inputs[i].s1 = tmp.inputs[i].s1;
                this.tagtable.add(this.inputs[i].s1);
                this.inputs[i].v2 = tmp.inputs[i].v2;
                this.tagtable.add(this.inputs[i].v2);
                this.inputs[i].s2 = tmp.inputs[i].s2;
                this.tagtable.add(this.inputs[i].s2);
                continue;
            }
            if (this.noscale || !tmp.noscale) continue;
            this.tagtable.remove(this.inputs[i].scaled);
            this.tagtable.remove(this.inputs[i].v1);
            this.tagtable.remove(this.inputs[i].s1);
            this.tagtable.remove(this.inputs[i].v2);
            this.tagtable.remove(this.inputs[i].s2);
            this.inputs[i].scaled = null;
            this.inputs[i].v1 = null;
            this.inputs[i].s1 = null;
            this.inputs[i].v2 = null;
            this.inputs[i].s2 = null;
        }
        this.nominus = tmp.nominus;
        this.noscale = tmp.noscale;
        return true;
    }

    protected static class Input {
        public Tag value;
        public Tag scaled;
        public Tag v1;
        public Tag s1;
        public Tag v2;
        public Tag s2;

        protected Input() {
        }
    }
}

