/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolMercury;

public class MercuryModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(MercuryModule.class);
    protected ProtocolMercury protocol = new ProtocolMercury(this);
    protected TagRW tagAuth;
    protected TagRW tagSN;
    protected TagRW tagDate;
    protected TagRW tagVersion;
    protected Tag tagEnergyAP;
    protected Tag tagEnergyAN;
    protected Tag tagEnergyRP;
    protected Tag tagEnergyRN;
    private int password;

    public MercuryModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.password = cm.get(conf, "password", 222222);
        this.tagAuth = this.tagtable.createRWBool("Auth", false);
        this.tagSN = this.tagtable.createRWInt("SN", 0, 8);
        this.tagDate = this.tagtable.createRWInt("Date", 0, 8);
        this.tagVersion = this.tagtable.createRWInt("Version", 0, 8);
        this.tagEnergyAP = this.tagtable.createLong("Energy.AP", 0L, 8);
        this.tagEnergyAN = this.tagtable.createLong("Energy.AN", 0L, 8);
        this.tagEnergyRP = this.tagtable.createLong("Energy.RP", 0L, 8);
        this.tagEnergyRN = this.tagtable.createLong("Energy.RN", 0L, 8);
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        this.addChannelMapTag(chtags, this.tagEnergyAP, "A+");
        this.addChannelMapTag(chtags, this.tagEnergyAN, "A-");
        this.addChannelMapTag(chtags, this.tagEnergyRP, "R+");
        this.addChannelMapTag(chtags, this.tagEnergyRN, "R-");
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean res = true;
        boolean auth = this.tagAuth.getBool();
        try {
            if (this.firstPass || this.tagError.getBool() || !this.tagAuth.getBool()) {
                auth = false;
                res = this.protocol.requestAuthClose();
                if (res && this.protocol.requestAuthOpen(this.password)) {
                    boolean bl = auth = this.protocol.getByte(1) == 0;
                }
                if (auth) {
                    res = this.protocol.requestInfo();
                }
                if (auth && res) {
                    this.tagSN.setReadValInt(this.protocol.getByte(1) * 1000000 + this.protocol.getByte(2) * 10000 + this.protocol.getByte(3) * 100 + this.protocol.getByte(4));
                    this.tagDate.setReadValInt((this.protocol.getByte(7) + 2000) * 10000 + this.protocol.getByte(6) * 100 + this.protocol.getByte(5));
                    this.tagVersion.setReadValInt(this.protocol.getByte(8) * 10000 + this.protocol.getByte(9) * 100 + this.protocol.getByte(10));
                }
            }
            if (auth && res && (res = this.protocol.requestEnergy())) {
                this.tagEnergyAP.setLong(this.protocol.getUInt32(1));
                this.tagEnergyAN.setLong(this.protocol.getUInt32(5));
                this.tagEnergyRP.setLong(this.protocol.getUInt32(9));
                this.tagEnergyRN.setLong(this.protocol.getUInt32(13));
            }
            if (this.tagAuth.getBool() != auth) {
                this.tagAuth.setReadValBool(auth);
                this.updateTagsStatus();
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            res = false;
        }
        return res;
    }

    @Override
    protected void updateTagsStatus() {
        this.tagtable.setTagState(this.tagError.getBool() || !this.tagAuth.getBool() ? Tag.Status.Bad : Tag.Status.Good, 8);
    }

    @Override
    protected boolean reload() {
        MercuryModule tmp = new MercuryModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.password = tmp.password;
        return true;
    }
}

