/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenMv110_8aModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenMv110_8aModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Input[] tagInp = null;
    protected final int sizeInp;
    protected final int regInp;

    public OwenMv110_8aModule(Plugin plugin, String name) {
        super(plugin, name);
        this.sizeInp = 8;
        this.regInp = 0;
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        if (this.tagInp == null) {
            this.tagInp = new Input[this.sizeInp];
        }
        for (int i = 0; i < this.sizeInp; ++i) {
            Input inp = new Input();
            String tagname = String.format("inp%02d", i);
            inp.dp = this.tagtable.createInt(tagname + ".dp", 0, 8);
            inp.val_int = this.tagtable.createInt(tagname + ".val.int", 0, 8);
            inp.status = this.tagtable.createInt(tagname + ".status", 0, 8);
            inp.time = this.tagtable.createInt(tagname + ".time", 0, 8);
            inp.val_double = this.tagtable.createDouble(tagname + ".val.double", 0.0, 8);
            this.tagInp[i] = inp;
        }
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < this.sizeInp; ++i) {
            this.addChannelMapTag(chtags, this.tagInp[i].val_int, "" + i);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            result &= this.readInputs();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    protected boolean readInputs() throws Exception {
        if (!this.protocol.requestCmd3(this.regInp, this.sizeInp * 6)) {
            return false;
        }
        for (int i = 0; i < this.sizeInp; ++i) {
            this.tagInp[i].dp.setInt(this.protocol.getAnswerWord(i * 6 + 0));
            this.tagInp[i].val_int.setInt(this.protocol.getAnswerWord(i * 6 + 1));
            this.tagInp[i].status.setInt(this.protocol.getAnswerWord(i * 6 + 2));
            this.tagInp[i].time.setInt(this.protocol.getAnswerWord(i * 6 + 3));
            this.tagInp[i].val_double.setDouble(this.protocol.getAnswerFloat(i * 6 + 4));
        }
        return true;
    }

    protected static final class Input {
        Tag val_int;
        Tag val_double;
        Tag dp;
        Tag time;
        Tag status;

        protected Input() {
        }
    }
}

