/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.SerialPort;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.CmdLogError;
import promauto.jroboplc.plugin.peripherial.CmdLogReq;
import promauto.utils.CRC;
import promauto.utils.Numbers;
import promauto.utils.Strings;

public class PeripherialModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(PeripherialModule.class);
    static DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HHmmss");
    public static final String TAGNAME_CHANNELMAP = "CHANNELMAP";
    protected TagRW tagPort;
    protected TagRW tagNetAddr;
    protected Tag tagError;
    protected Tag tagErrorCnt;
    protected Tag tagTimePeriod;
    protected Tag tagUpdateDate;
    protected Tag tagUpdateTime;
    protected Tag tagCrc16;
    protected Tag tagCrc32;
    protected Tag tagSN;
    protected List<TagRW> tagChannelMap;
    protected int portnum;
    protected int netaddr;
    protected int retrial;
    protected boolean emulated;
    protected String type;
    protected String descr;
    protected String systagpref;
    protected volatile int logErrorCnt;
    protected volatile int logReqCnt;
    protected int delay;
    protected SerialPort port;
    protected List<Tag> crc16Tags;
    protected List<Tag> crc32Tags;
    protected boolean firstPass;
    protected boolean useSN;

    public PeripherialModule(Plugin plugin, String name) {
        super(plugin, name);
        this.env.getCmdDispatcher().addCommand(this, CmdLogError.class);
        this.env.getCmdDispatcher().addCommand(this, CmdLogReq.class);
        this.useSN = false;
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.portnum = cm.get(conf, "portnum", 0);
        this.netaddr = cm.get(conf, "netaddr", 0);
        this.emulated = cm.get(conf, "emulate", false);
        this.type = cm.get(conf, "type", "");
        this.descr = cm.get(conf, "descr", "");
        this.systagpref = cm.get(conf, "systag", "SYSTEM.");
        this.retrial = Math.max(1, cm.get(conf, "retrial", 1));
        this.logErrorCnt = cm.get(conf, "logerror", 0);
        this.logReqCnt = cm.get(conf, "logreq", 0);
        this.delay = cm.get(conf, "delay_ms", 0);
        this.tagError = this.tagtable.createBool(this.systagpref + "ErrorFlag", false);
        this.tagErrorCnt = this.tagtable.createInt(this.systagpref + "ErrorCount", 0);
        this.tagTimePeriod = this.tagtable.createInt(this.systagpref + "TimePeriod", 0);
        this.tagUpdateDate = this.tagtable.createInt(this.systagpref + "UpdateDate", 0);
        this.tagUpdateTime = this.tagtable.createInt(this.systagpref + "UpdateTime", 0);
        this.tagPort = this.tagtable.createRWInt(this.systagpref + "Port", this.portnum);
        this.tagNetAddr = this.tagtable.createRWInt(this.systagpref + "NetAddr", this.netaddr);
        if (this.useSN) {
            this.tagSN = this.tagtable.createString(this.systagpref + "SN", "", 1);
        }
        if (!this.loadPeripherialModule(conf)) {
            return false;
        }
        if (cm.get(conf, "chmap", false)) {
            this.createChannelMap(cm.get(conf, "chmap.name", ""), cm.get(conf, "chmap.value", ""));
        }
        return true;
    }

    protected void initCrc16Tags() {
        this.tagCrc16 = this.tagtable.createInt("Crc16", 0);
        this.crc16Tags = new ArrayList<Tag>();
    }

    protected void initCrc32Tags() {
        this.tagCrc32 = this.tagtable.createLong("Crc32", 0L);
        this.crc32Tags = new ArrayList<Tag>();
    }

    protected void addCrc32Tags(Object ... tags) {
        if (this.crc32Tags == null) {
            this.initCrc32Tags();
        }
        for (Object obj : tags) {
            if (obj instanceof Tag) {
                this.crc32Tags.add((Tag)obj);
                continue;
            }
            Tag tag = this.tagtable.get(obj.toString());
            if (tag == null) {
                throw new RuntimeException("Crc32Tag not found: " + obj);
            }
            this.crc32Tags.add(tag);
        }
    }

    protected boolean loadPeripherialModule(Object conf) {
        return true;
    }

    private void createChannelMap(String chmapName, String chmapValue) {
        ArrayList<String> chtags = new ArrayList<String>();
        if (chmapValue.isEmpty()) {
            this.initChannelMap(chtags);
        } else {
            chtags.addAll(Arrays.asList(chmapValue.trim().split("\\s+")));
        }
        if (chtags.size() == 0) {
            return;
        }
        String header = this.name + (chmapName.trim().isEmpty() ? "" : ":" + chmapName);
        int headerlen = header.length();
        this.tagChannelMap = new ArrayList<TagRW>();
        StringBuilder sb = new StringBuilder();
        int tagidx = 0;
        for (String chtag : chtags) {
            chtag = ' ' + chtag.trim();
            if (headerlen + sb.length() + chtag.length() > 4096) {
                this.createTagChannelMap(tagidx, header + sb.toString());
                sb.setLength(0);
                ++tagidx;
            }
            sb.append(chtag);
        }
        if (sb.length() > 0) {
            this.createTagChannelMap(tagidx, header + sb.toString());
        }
    }

    private void createTagChannelMap(int tagidx, String value) {
        this.tagChannelMap.add(this.tagtable.createRWString(this.systagpref + TAGNAME_CHANNELMAP + '.' + tagidx, value));
    }

    protected void addChannelMapTag(List<String> chtags, Tag tag, String shortTagname) {
        if (tag.getName().equals(shortTagname)) {
            chtags.add(tag.getName());
        } else {
            chtags.add(String.format("%s:%s", tag.getName(), shortTagname));
        }
    }

    protected void addChannelMapTag(List<String> chtags, Tag tag) {
        chtags.add(tag.getName());
    }

    protected void initChannelMap(List<String> chtags) {
    }

    @Override
    public final boolean prepareModule() {
        this.port = null;
        this.firstPass = true;
        this.tagError.setBool(true);
        this.tagtable.setTagState(Tag.Status.Bad, 8);
        return this.preparePeripherialModule();
    }

    protected boolean preparePeripherialModule() {
        return true;
    }

    @Override
    public final boolean executeModule() {
        boolean hasStatusChanged;
        long timems = System.currentTimeMillis();
        boolean res = true;
        if (!(this.emulated || this.port != null && this.port.isValid())) {
            this.port = this.env.getSerialManager().getPort(this.portnum);
            if (this.port == null) {
                res = false;
            }
        }
        int tmpUpdateDate = Integer.parseInt(LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        int tmpUpdateTime = Integer.parseInt(LocalTime.now().format(timeFormatter));
        if (res) {
            res = this.executePeripherialModule();
        }
        if (this.useSN && res && (this.firstPass || this.tagError.getBool())) {
            res = this.requestSN();
        }
        boolean bl = hasStatusChanged = this.tagError.getBool() == res;
        if (this.emulated) {
            if (this.firstPass) {
                this.tagError.setBool(false);
            }
        } else {
            this.tagError.setBool(!res);
        }
        this.tagUpdateDate.setInt(tmpUpdateDate);
        this.tagUpdateTime.setInt(tmpUpdateTime);
        if (hasStatusChanged) {
            this.updateTagsStatus();
        }
        int tp = (int)(System.currentTimeMillis() - timems);
        if (this.tagTimePeriod.getInt() == tp) {
            ++tp;
        }
        this.tagTimePeriod.setInt(tp);
        this.calcCrc16();
        this.calcCrc32();
        if (hasStatusChanged) {
            this.env.logInfo(this.logger, (res ? "Connected" : "Disconnected") + ": " + this.name);
        }
        this.firstPass = false;
        return res;
    }

    protected boolean requestSN() {
        if (!this.checkFakeSn(this.tagSN.getString())) {
            this.tagSN.setString(this.generateFakeSN());
        }
        return true;
    }

    private String generateFakeSN() {
        byte[] nonce = new byte[8];
        new SecureRandom().nextBytes(nonce);
        String sn = Strings.bytesToHexString(nonce, "");
        int crc = CRC.getCrc16(sn.getBytes());
        return sn + Numbers.toHexString(crc);
    }

    private boolean checkFakeSn(String sn) {
        if (sn.length() != 20) {
            return false;
        }
        try {
            int crc = CRC.getCrc16(sn.substring(0, 16).getBytes());
            if (crc != Integer.parseInt(sn.substring(16), 16)) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected void updateTagsStatus() {
        this.tagtable.setTagState(this.tagError.getBool() ? Tag.Status.Bad : Tag.Status.Good, 8);
    }

    protected void calcTagCrc8(Tag[] crcTags, Tag tagCrc, int[] buff) {
        if (buff.length < crcTags.length * 2) {
            tagCrc.setInt(-1);
            return;
        }
        int i = 0;
        for (Tag tag : crcTags) {
            int v = tag.getInt();
            buff[i++] = v >> 8 & 0xFF;
            buff[i++] = v & 0xFF;
        }
        tagCrc.setInt(CRC.getCrc8(buff, 0, crcTags.length * 2 - 1));
    }

    public void calcCrc16() {
        if (this.crc16Tags != null && this.tagCrc16 != null) {
            this.tagCrc16.setInt(CRC.getCrc16FromWordStream(this.crc16Tags.stream().map(Tag::getInt)));
        }
    }

    public void calcCrc32() {
        if (this.crc32Tags != null && this.tagCrc32 != null) {
            this.tagCrc32.setLong(CRC.getOctoCrc32FromTagStream(this.crc32Tags.stream()));
        }
    }

    protected boolean executePeripherialModule() {
        return true;
    }

    @Override
    public String getInfo() {
        return !this.enable ? "disabled" : (this.emulated ? "emulated" : String.format("%sp%-3d a%-3d errcnt=%d %s %s", this.tagError.getBool() ? ANSI.redBold("ERROR! ") : "", this.portnum, this.netaddr, this.tagErrorCnt.getInt(), this.type, this.descr));
    }

    protected static long updateWesSvrState(TagRW tag, long timer) {
        if (tag.hasWriteValue()) {
            tag.setReadValInt(tag.getWriteValInt() | 1);
            timer = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - timer > 10000L) {
            tag.setReadValInt(0);
        }
        return timer;
    }

    @Override
    public void copySettingsFrom(AbstractModule src) {
        PeripherialModule tmp = (PeripherialModule)src;
        super.copySettingsFrom(tmp);
        this.portnum = tmp.portnum;
        this.netaddr = tmp.netaddr;
        this.retrial = tmp.retrial;
        this.emulated = tmp.emulated;
        this.type = tmp.type;
        this.descr = tmp.descr;
        this.systagpref = tmp.systagpref;
        this.logErrorCnt = tmp.logErrorCnt;
        this.logReqCnt = tmp.logReqCnt;
        this.delay = tmp.delay;
        this.tagPort.setReadValInt(tmp.portnum);
        this.tagNetAddr.setReadValInt(tmp.netaddr);
        this.port = null;
        this.firstPass = true;
    }

    @Override
    protected boolean reload() {
        PeripherialModule tmp = new PeripherialModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedown();
        this.copySettingsFrom(tmp);
        return this.prepare();
    }

    @Override
    public void saveState(State state) {
        this.tagtable.values().stream().filter(tag -> tag != this.tagPort && tag != this.tagNetAddr).forEach(tag -> state.saveTag((Tag)tag));
    }

    @Override
    public void loadState(State state) {
        this.tagtable.values().stream().forEach(tag -> state.loadTag((Tag)tag));
    }

    public boolean canLogError() {
        if (this.logErrorCnt <= 0) {
            return false;
        }
        --this.logErrorCnt;
        return true;
    }

    public boolean canLogReq() {
        if (this.logReqCnt <= 0) {
            return false;
        }
        --this.logReqCnt;
        return true;
    }

    public void logReq(int[] buffout, int sizeout, int[] buffin, int sizein) {
        EnvironmentInst.get().printInfo(this.logger, String.format("%s - request:\r\n%s\r\nanswer:\r\n%s\r\n\r\n", this.name, Strings.bytesToHexString(buffout, 0, sizeout), Strings.bytesToHexString(buffin, 0, sizein)));
    }

    public void logError(int trynum, boolean badcrc, int[] buffout, int sizeout, int[] buffin, int sizein, String text) {
        int i;
        sizein = Math.abs(sizein);
        StringBuilder sb = new StringBuilder();
        sb.append("error ").append(badcrc ? "crc" : "read");
        sb.append(", try=").append(trynum).append("\r\n");
        sb.append(", out:");
        for (i = 0; i < sizeout && i < buffout.length; ++i) {
            sb.append(" ").append(Numbers.toHexString(buffout[i], 2));
        }
        sb.append(", len=").append(sizeout).append("\r\n");
        sb.append(", inp:");
        for (i = 0; i < sizein && i < buffin.length; ++i) {
            sb.append(" ").append(Numbers.toHexString(buffin[i], 2));
        }
        sb.append(", len=").append(sizein).append("\r\n");
        if (!text.isEmpty()) {
            sb.append(", ").append(text);
        }
        sb.append("\r\n\r\n");
        this.logError(sb.toString());
    }

    public void logError(String text) {
        EnvironmentInst.get().printError(this.logger, this.name, text + (this.logErrorCnt == 0 ? "\r\nNo more further logging!" : ""));
    }

    public void logDebug(int[] buffout, int sizeout, int[] buffin, int sizein, String text) {
        this.logger.debug(String.format("%s\t req: %s\t ans: %s %s", this.name, Strings.bytesToHexString(buffout, 0, sizeout), Strings.bytesToHexString(buffin, 0, sizein), text));
    }

    public void logDebug(int[] buffout, int sizeout, String text) {
        this.logger.debug(String.format("%s\t req: %s\t ans: %s", this.name, Strings.bytesToHexString(buffout, 0, sizeout), text));
    }

    public void logDebug(String text) {
        this.logger.debug(String.format("%s\t %s", this.name, text));
    }

    public void delayBeforeWrite() {
        if (this.delay > 0) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void delayAfterError() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

