/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class SchneiderAtv31Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(SchneiderAtv31Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected TagRW tagCmd;
    protected TagRW tagLfr;
    protected Tag tagEta;
    protected Tag tagRfr;
    protected Tag tagFrh;
    protected Tag tagLcr;
    protected Tag tagOtr;
    protected Tag tagEti;
    protected Tag tagUln;
    Map<Integer, Integer> initRegs = new HashMap<Integer, Integer>();
    boolean initiated;
    boolean keepFreqSet;

    public SchneiderAtv31Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagCmd = this.protocol.addWriteTag(8501, this.tagtable.createRWInt("Control.CMD", 0, 8));
        this.tagLfr = this.protocol.addWriteTag(8502, this.tagtable.createRWInt("FreqSet.LFr", 0, 8));
        this.tagEta = this.tagtable.createInt("Status.ETA", 0, 8);
        this.tagRfr = this.tagtable.createInt("FreqOut.rFr", 0, 8);
        this.tagFrh = this.tagtable.createInt("FreqReq.FrH", 0, 8);
        this.tagLcr = this.tagtable.createInt("Current.LCr", 0, 8);
        this.tagOtr = this.tagtable.createInt("Torque.Otr", 0, 8);
        this.tagEti = this.tagtable.createInt("Status.ETI", 0, 8);
        this.tagUln = this.tagtable.createInt("Voltage.ULn", 0, 8);
        Configuration cm = this.env.getConfiguration();
        cm.toGenericMap(cm.get(conf, "init.regs")).forEach((key, value) -> this.initRegs.put(Integer.parseInt(key.toString()), Integer.parseInt(value.toString())));
        this.keepFreqSet = cm.get(conf, "KeepFreqSet", false);
        if (this.keepFreqSet) {
            this.tagLfr.setFlags(1);
        }
        return true;
    }

    @Override
    protected boolean preparePeripherialModule() {
        this.initiated = false;
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagCmd.acceptWriteValue();
            this.tagLfr.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            if (!this.initiated) {
                for (Map.Entry<Integer, Integer> ent : this.initRegs.entrySet()) {
                    if (result) {
                        result = this.protocol.requestCmd3(ent.getKey(), 1);
                    }
                    if (!result || ent.getValue().intValue() == this.protocol.getAnswerWord(0)) continue;
                    result = this.protocol.requestCmd6(ent.getKey(), ent.getValue());
                }
            }
            if (result) {
                result = this.protocol.sendWriteTags(6);
            }
            if (result && (result = this.protocol.requestCmd3(8501, 2))) {
                this.tagCmd.setReadValInt(this.protocol.getAnswerWord(0));
                int lfr = this.decodeFreq(this.protocol.getAnswerWord(1));
                if (this.keepFreqSet && lfr != this.tagLfr.getWriteValInt()) {
                    this.tagLfr.raiseWriteValue();
                }
                this.tagLfr.setReadValInt(lfr);
            }
            if (result && (result = this.protocol.requestCmd3(3201, 7))) {
                this.tagEta.setInt(this.protocol.getAnswerWord(0));
                this.tagRfr.setInt(this.decodeFreq(this.protocol.getAnswerWord(1)));
                this.tagFrh.setInt(this.protocol.getAnswerWord(2));
                this.tagLcr.setInt(this.protocol.getAnswerWord(3));
                this.tagOtr.setInt(this.protocol.getAnswerWord(4));
                this.tagEti.setInt(this.protocol.getAnswerWord(5));
                this.tagUln.setInt(this.protocol.getAnswerWord(6));
            }
            this.initiated = result;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    private int decodeFreq(int freq) {
        if (freq < 32768) {
            return freq;
        }
        return freq - 65536;
    }

    @Override
    protected boolean reload() {
        SchneiderAtv31Module tmp = new SchneiderAtv31Module(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.keepFreqSet = tmp.keepFreqSet;
        this.initRegs = tmp.initRegs;
        return true;
    }
}

