/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.Numbers;

public class SchuleFlowModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(SchuleFlowModule.class);
    private static int BUFF_SIZE = 60;
    protected int[] buffin = new int[BUFF_SIZE];
    protected int[] buffout = new int[BUFF_SIZE];
    protected Tag tagCrc;
    protected Tag tagState;
    protected Tag tagActFlow;
    protected Tag tagTrgFlow;
    protected Tag tagTotalSumH;
    protected Tag tagTotalSumL;
    protected Tag tagProdType;
    protected Tag tagAlarmCode;
    protected Tag tagTrgPresel;
    protected Tag tagRestPresel;
    protected Tag tagPreselExpir;
    protected Tag tagLenActive;
    protected Tag tagActualLen;
    protected Tag tagLenCtrl;
    protected Tag tagTrgLen;
    protected Tag tagSetState;
    protected Tag tagSetTrgFlow;
    protected Tag tagRstTotalSum;
    protected Tag tagSetProdType;
    protected Tag tagSetTrgPresel;
    protected Tag tagSetLenCtrl;
    protected Tag tagSetTrgLen;
    protected TagRW tagWesSvrState;
    private long wesSvrStateTimer;
    protected Tag[] crcTags;

    public SchuleFlowModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagCrc = this.tagtable.createInt("Crc", 0);
        this.tagState = this.tagtable.createInt("State", 0, 8);
        this.tagActFlow = this.tagtable.createInt("ActFlow", 0, 8);
        this.tagTrgFlow = this.tagtable.createInt("TrgFlow", 0, 8);
        this.tagTotalSumH = this.tagtable.createInt("TotalSumH", 0, 8);
        this.tagTotalSumL = this.tagtable.createInt("TotalSumL", 0, 8);
        this.tagProdType = this.tagtable.createInt("ProdType", 0, 8);
        this.tagAlarmCode = this.tagtable.createInt("AlarmCode", 0, 8);
        this.tagTrgPresel = this.tagtable.createInt("TrgPresel", 0, 8);
        this.tagRestPresel = this.tagtable.createInt("RestPresel", 0, 8);
        this.tagPreselExpir = this.tagtable.createInt("PreselExpir", 0, 8);
        this.tagLenActive = this.tagtable.createInt("LenActive", 0, 8);
        this.tagActualLen = this.tagtable.createInt("ActualLen", 0, 8);
        this.tagLenCtrl = this.tagtable.createInt("LenCtrl", 0, 8);
        this.tagTrgLen = this.tagtable.createInt("TrgLen", 0, 8);
        this.tagSetState = this.tagtable.createInt("SetState", 0, 8);
        this.tagSetTrgFlow = this.tagtable.createInt("SetTrgFlow", 0, 8);
        this.tagRstTotalSum = this.tagtable.createInt("RstTotalSum", 0, 8);
        this.tagSetProdType = this.tagtable.createInt("SetProdType", 0, 8);
        this.tagSetTrgPresel = this.tagtable.createInt("SetTrgPresel", 0, 8);
        this.tagSetLenCtrl = this.tagtable.createInt("SetLenCtrl", 0, 8);
        this.tagSetTrgLen = this.tagtable.createInt("SetTrgLen", 0, 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        this.crcTags = new Tag[]{this.tagTotalSumH, this.tagTotalSumL};
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (!this.emulated) {
            try {
                this.buffout[0] = 221;
                this.buffout[1] = 221;
                this.buffout[2] = 60;
                this.buffout[3] = this.netaddr;
                this.buffout[4] = 0;
                this.buffout[5] = 0;
                this.setCmd(this.tagState, this.tagSetState, 6, 2);
                this.setZero(10, 4);
                this.setCmd(this.tagTrgFlow, this.tagSetTrgFlow, 14, 4);
                this.setZero(20, 6);
                this.setCmd(this.tagProdType, this.tagSetProdType, 26, 2);
                this.setZero(30, 4);
                this.setCmd(this.tagTrgPresel, this.tagSetTrgPresel, 34, 4);
                this.setZero(40, 10);
                this.setCmd(this.tagLenCtrl, this.tagSetLenCtrl, 50, 2);
                this.setCmd(this.tagTrgLen, this.tagSetTrgLen, 54, 2);
                this.buffout[58] = 32;
                this.buffout[59] = 32;
                result = this.request();
                if (result) {
                    this.tagState.setInt(Numbers.bytesToWord(this.buffin, 8));
                    this.tagActFlow.setInt(Numbers.bytesToInt(this.buffin, 10));
                    this.tagTrgFlow.setInt(Numbers.bytesToInt(this.buffin, 16));
                    this.tagTotalSumH.setInt(Numbers.bytesToWord(this.buffin, 22));
                    this.tagTotalSumL.setInt(Numbers.bytesToWord(this.buffin, 24));
                    this.tagProdType.setInt(Numbers.bytesToWord(this.buffin, 28));
                    this.tagAlarmCode.setInt(Numbers.bytesToWord(this.buffin, 30));
                    this.tagTrgPresel.setInt(Numbers.bytesToInt(this.buffin, 36));
                    this.tagRestPresel.setInt(Numbers.bytesToInt(this.buffin, 40));
                    this.tagPreselExpir.setInt(Numbers.bytesToWord(this.buffin, 44));
                    this.tagLenActive.setInt(Numbers.bytesToWord(this.buffin, 46));
                    this.tagActualLen.setInt(Numbers.bytesToWord(this.buffin, 48));
                    this.tagLenCtrl.setInt(Numbers.bytesToWord(this.buffin, 52));
                    this.tagTrgLen.setInt(Numbers.bytesToWord(this.buffin, 56));
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                result = false;
            }
        }
        this.calcTagCrc8(this.crcTags, this.tagCrc, this.buffin);
        this.wesSvrStateTimer = SchuleFlowModule.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        return result;
    }

    private void setZero(int idx, int size) {
        for (int i = 0; i < size; ++i) {
            this.buffin[i] = 0;
        }
    }

    private void setCmd(Tag tagRead, Tag tagWrite, int addr, int size) {
        if (tagRead.getInt() == tagWrite.getInt()) {
            this.setZero(addr, size * 2 + 2);
        } else {
            this.buffout[addr] = 0;
            this.buffout[addr + 1] = 1;
            int v = tagWrite.getInt();
            for (int i = 0; i < size; ++i) {
                this.buffout[addr + size - i + 1] = v >> 8 * i & 0xFF;
            }
        }
    }

    private boolean request() throws Exception {
        if (this.port == null) {
            return false;
        }
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            this.port.discard();
            this.port.writeBytes(this.buffout, BUFF_SIZE);
            int n = this.port.readBytes(this.buffin, BUFF_SIZE);
            boolean badcrc = false;
            if (n > 0) {
                if (n == BUFF_SIZE && this.buffin[0] == 221 && this.buffin[1] == 221 && this.buffin[2] == 60 && this.buffin[3] == this.netaddr && this.buffin[58] == 32 && this.buffin[59] == 32) {
                    return true;
                }
                badcrc = true;
            }
            if (this.canLogError()) {
                int cntRead = Math.abs(n);
                this.logError(trynum, badcrc, this.buffout, BUFF_SIZE, this.buffin, cntRead, "");
            }
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }
}

