/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolTenzom;

public class TenzomModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(TenzomModule.class);
    protected ProtocolTenzom protocol = new ProtocolTenzom(this);
    List<Counter> counters = new ArrayList<Counter>();
    protected int size;
    Tag tagStatus;
    Tag tagNetto;
    Tag tagBrutto;
    private boolean useCounters;
    private boolean useStatus;
    private boolean useNetto;
    private boolean useBrutto;
    private boolean stableNetto;
    private boolean stableBrutto;

    public TenzomModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.useCounters = cm.get(conf, "useCounters", true);
        this.useStatus = cm.get(conf, "useStatus", true);
        this.useNetto = cm.get(conf, "useNetto", false);
        this.useBrutto = cm.get(conf, "useBrutto", false);
        this.stableNetto = cm.get(conf, "stableNetto", false);
        this.stableBrutto = cm.get(conf, "stableBrutto", false);
        this.size = 0;
        this.addCounter("SumWeight", cm.get(conf, "posSumWeight", 1));
        this.addCounter("SumNum", cm.get(conf, "posSumNum", 2));
        this.addCounter("LastWeight", cm.get(conf, "posLastWeight", 3));
        this.addCounter("Output", cm.get(conf, "posOutput", 4));
        this.addCounter("LastTime", cm.get(conf, "posLastTime", 5));
        this.tagStatus = this.tagtable.createInt("Status", 0, 8);
        this.tagNetto = this.tagtable.createInt("Netto", 0, 8);
        this.tagBrutto = this.tagtable.createInt("Brutto", 0, 8);
        return true;
    }

    private void addCounter(String tagname, int pos) {
        Counter counter = new Counter();
        counter.tag = this.tagtable.createLong(tagname, 0L, 8);
        if (pos > 0 && pos < 9) {
            counter.offset = pos * 5 + 3;
            this.size = Math.max(this.size, pos);
        } else {
            counter.offset = 0;
        }
        this.counters.add(counter);
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            if (this.useCounters && result && (result = this.protocol.requestCounters(this.size))) {
                for (Counter counter : this.counters) {
                    if (counter.offset <= 0) continue;
                    counter.tag.setLong(this.protocol.getBCDValue(counter.offset, 5));
                }
            }
            if (this.useStatus && result && (result = this.protocol.requestValue(191, 1))) {
                this.tagStatus.setInt(this.protocol.buffin[2]);
            }
            if (this.useBrutto && result && (result = this.protocol.requestValue(195, 4))) {
                this.setValue(this.tagBrutto, this.stableBrutto);
            }
            if (this.useNetto && result && (result = this.protocol.requestValue(194, 4))) {
                this.setValue(this.tagNetto, this.stableNetto);
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    private void setValue(Tag tag, boolean onlyStable) {
        int con = this.protocol.buffin[5];
        if (onlyStable && (con & 0x10) == 0) {
            return;
        }
        int sign = (con & 0x80) > 0 ? -1 : 1;
        int mul = (int)Math.pow(10.0, 3 - (con & 3));
        tag.setInt(sign * mul * (int)this.protocol.getBCDValue(2, 3));
    }

    @Override
    protected boolean reload() {
        TenzomModule tmp = new TenzomModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.size = tmp.size;
        for (int i = 0; i < this.counters.size(); ++i) {
            this.counters.get((int)i).offset = tmp.counters.get((int)i).offset;
        }
        this.useCounters = tmp.useCounters;
        this.useStatus = tmp.useStatus;
        this.useNetto = tmp.useNetto;
        this.useBrutto = tmp.useBrutto;
        this.stableNetto = tmp.stableNetto;
        this.stableBrutto = tmp.stableBrutto;
        return true;
    }

    private static class Counter {
        Tag tag;
        int offset;

        private Counter() {
        }
    }
}

