/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PaTermo5Module;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;

public class TermoMuxModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaTermo5Module.class);
    static final int VALUES_OFFSET = 3;
    static final int VALUE_SIZE = 5;
    static final int PDV_COUNT = 8;
    static final int T_COUNT = 12;
    private int[] bufout = new int[5];
    private int[] bufinp = new int[66];
    private int[] bufinp1 = new int[61];
    private boolean shortAnswer;
    public Pdv[] pdvs = new Pdv[8];

    public TermoMuxModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        for (int i = 0; i < 8; ++i) {
            Pdv pdv;
            this.pdvs[i] = pdv = new Pdv();
            String s = "Pdv" + i + ".";
            for (int j = 0; j < 12; ++j) {
                pdv.tagT[j] = this.tagtable.createInt(s + "T" + j, 0, 8);
            }
            pdv.tagTime = this.tagtable.createInt(s + "Time", 0, 8);
        }
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 12; ++j) {
                this.addChannelMapTag(chtags, this.pdvs[i].tagT[j], i + "." + j);
            }
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            for (int i = 0; i < 8 && (result = this.request(i)); ++i) {
                int j;
                Pdv pdv = this.pdvs[i];
                int tnum = 0;
                if (this.shortAnswer) {
                    pdv.tagTime.setInt(2000);
                } else {
                    for (j = 7; j >= 0; --j) {
                        int value = this.getValue(j);
                        pdv.tagT[tnum].setInt(value);
                        if (value == -999 && tnum <= 0) continue;
                        ++tnum;
                    }
                    pdv.tagTime.setInt(10);
                }
                for (j = tnum; j < 12; ++j) {
                    pdv.tagT[j].setInt(-999);
                }
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    private int getValue(int num) {
        int k = this.getPos(num);
        int value = (this.bufinp[k + 1] - 48) * 100;
        value += (this.bufinp[k + 2] - 48) * 10;
        value += this.bufinp[k + 4] - 48;
        value = this.bufinp[k] == 45 ? (value *= -1) : (value += (this.bufinp[k] - 48) * 1000);
        return value;
    }

    private int getPos(int num) {
        return 3 + 5 * num;
    }

    public boolean request(int pdvnum) throws Exception {
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            this.port.discard();
            this.delayBeforeWrite();
            int n = 0;
            this.bufout[0] = 62;
            this.bufout[1] = 63 + this.netaddr;
            this.bufout[2] = 83;
            this.bufout[3] = 48 + pdvnum;
            this.bufout[4] = 13;
            this.port.writeBytes(this.bufout, 5);
            if (this.port.readBytes(this.bufinp, 5) == 5 && this.bufinp[0] == 60 && this.bufinp[1] == 1 && this.bufinp[2] == this.bufout[1]) {
                if (this.bufinp[3] == 21 && this.bufinp[4] == 13) {
                    this.shortAnswer = true;
                    return true;
                }
                this.shortAnswer = false;
                if (this.port.readBytes(this.bufinp1, 61) == 61) {
                    System.arraycopy(this.bufinp1, 0, this.bufinp, 5, 61);
                    if (this.bufinp[63] == 48 && this.bufinp[65] == 13 && this.checkLongAnswer() && this.checkCrc()) {
                        return true;
                    }
                }
            }
            if (this.canLogError()) {
                this.logError(trynum, false, this.bufout, this.bufout.length, this.bufinp, n, "pdvnum=" + pdvnum);
            }
            this.delayAfterError();
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }

    private boolean checkCrc() {
        int len = 63;
        int crc = 0;
        for (int i = 0; i < len; ++i) {
            crc += this.bufinp[i];
        }
        return (crc &= 0xFF) == this.bufinp[len + 1];
    }

    private boolean checkLongAnswer() {
        for (int i = 0; i < 12; ++i) {
            int k = this.getPos(i);
            boolean res = this.bufinp[k] == 45 || this.isDigit(this.bufinp[k]);
            int n = ++k;
            res &= this.isDigit(this.bufinp[n]);
            int n2 = ++k;
            res &= this.isDigit(this.bufinp[n2]);
            int n3 = ++k;
            res &= this.bufinp[n3] == 46;
            if (res &= this.isDigit(this.bufinp[++k])) continue;
            return false;
        }
        return true;
    }

    private boolean isDigit(int b) {
        return b >= 48 && b <= 57;
    }

    public static class Pdv {
        Tag[] tagT = new Tag[12];
        public Tag tagTime;
    }
}

