/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.List;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceKARTUSEQ
extends Device {
    private static int KART_SEQ_LNG = 8;
    private static int KART_SEQ_NOOUT = -1;
    Input inpEnable;
    Input tagTransportOk;
    List<Input> inpWork = new ArrayList<Input>(KART_SEQ_LNG);
    List<Input> inpClean = new ArrayList<Input>(KART_SEQ_LNG);
    List<Input> inpDVU = new ArrayList<Input>(KART_SEQ_LNG);
    List<Input> inpPDP = new ArrayList<Input>(KART_SEQ_LNG);
    List<Input> inpZDVOK = new ArrayList<Input>(KART_SEQ_LNG);
    List<Tag> Outs = new ArrayList<Tag>(KART_SEQ_LNG);
    List<Tag> MaxTime = new ArrayList<Tag>(KART_SEQ_LNG);
    Tag tagFlow;
    Tag tagState;
    Tag tagNextSeq;
    Tag tagConrtol;
    Tag tagMaxNumber;
    int iCurOutput;
    int iMaxOutputs;
    int iLastOutput;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.iCurOutput = KART_SEQ_NOOUT;
        this.iLastOutput = KART_SEQ_NOOUT;
        this.inpEnable = this.getInput("Enable", res);
        this.tagTransportOk = this.getInput("TransportOk", res);
        block0: for (Input inp : this.inputs) {
            boolean bFound = false;
            for (int pos = 1; pos <= KART_SEQ_LNG; ++pos) {
                if (inp.name.compareTo("Work" + pos) == 0) {
                    this.inpWork.add(inp);
                    bFound = true;
                }
                if (inp.name.compareTo("Clean" + pos) == 0) {
                    this.inpClean.add(inp);
                    bFound = true;
                }
                if (inp.name.compareTo("DVU" + pos) == 0) {
                    this.inpDVU.add(inp);
                    bFound = true;
                }
                if (inp.name.compareTo("PDP" + pos) == 0) {
                    this.inpPDP.add(inp);
                    bFound = true;
                }
                if (inp.name.compareTo("ZDVOK" + pos) == 0) {
                    this.inpZDVOK.add(inp);
                    bFound = true;
                }
                if (bFound) continue block0;
            }
        }
        for (int i = 1; i <= KART_SEQ_LNG; ++i) {
            this.Outs.add(i - 1, this.getOutputTag("_Out" + i, res));
            this.MaxTime.add(i - 1, this.getOutputTag("Time" + i, res));
        }
        this.tagConrtol = this.getOutputTag("Control", res);
        this.tagNextSeq = this.getOutputTag("NextSeq", res);
        this.tagMaxNumber = this.getOutputTag("MaxNumb", res);
        this.tagFlow = this.getOutputTag("Flow", res);
        this.tagState = this.getOutputTag("State", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagState.setInt(0);
    }

    @Override
    public boolean execute() {
        boolean bEnable;
        boolean bl = bEnable = this.inpEnable.getInt() == 1;
        if (!bEnable) {
            this.turnOffOuts();
        } else {
            boolean bFillTransportOk = this.tagTransportOk.getInt() == 1;
            this.iMaxOutputs = this.tagMaxNumber.getInt() == 0 ? KART_SEQ_LNG : this.tagMaxNumber.getInt();
            int tmpLast = this.iLastOutput;
            this.iLastOutput = this.getLastToFill(this.iMaxOutputs);
            if (tmpLast != this.iLastOutput) {
                this.turnOffOut(tmpLast);
            }
            if (this.canMakeFlow(this.iCurOutput)) {
                if (bFillTransportOk) {
                    this.turnOnOut(this.iCurOutput);
                } else if (this.iCurOutput != this.iLastOutput) {
                    this.turnOffOut(this.iCurOutput);
                }
                this.turnOnOut(this.iLastOutput);
            } else {
                int i;
                int iLastCnt = this.iLastOutput == KART_SEQ_NOOUT ? this.iMaxOutputs : this.iLastOutput;
                boolean bFound = false;
                for (i = 0; i <= iLastCnt; ++i) {
                    if (!this.canMakeFlow(i)) continue;
                    if (bFillTransportOk) {
                        this.switchOuts(i);
                    } else {
                        this.turnOffOutsAndSwap(i);
                    }
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    boolean bl2 = bFound = this.canJustWork(this.iCurOutput) && bFillTransportOk;
                }
                if (!bFound) {
                    for (i = 0; i <= iLastCnt; ++i) {
                        if (!this.canJustWork(i)) continue;
                        if (bFillTransportOk) {
                            this.switchOuts(i);
                        } else {
                            this.turnOffOutsAndSwap(i);
                        }
                        bFound = true;
                        break;
                    }
                }
                if (!bFound) {
                    this.turnOffOuts();
                    this.turnOnOut(this.iLastOutput);
                }
            }
        }
        if (this.iCurOutput == this.iLastOutput) {
            this.tagFlow.setInt(this.canMakeFlow(this.iLastOutput) ? 1 : 0);
        } else {
            this.tagFlow.setInt(this.canMakeFlow(this.iCurOutput) && this.canJustWork(this.iLastOutput) ? 1 : 0);
        }
        return this.finish();
    }

    private void switchOuts(int i) {
        this.turnOffOut(this.iCurOutput);
        this.iCurOutput = i;
        this.turnOnOut(this.iCurOutput);
    }

    private void turnOffOutsAndSwap(int i) {
        this.turnOffOut(this.iCurOutput);
        this.iCurOutput = i;
    }

    private int getLastToFill(int iMaxOuts) {
        for (int i = --iMaxOuts; i >= this.iCurOutput; --i) {
            if (!this.canUseDirection(i)) continue;
            return i;
        }
        return KART_SEQ_NOOUT;
    }

    private boolean canMakeFlow(int curPos) {
        if (curPos < 0 || curPos >= this.inpPDP.size()) {
            return false;
        }
        return this.inpWork.get(curPos).getInt() + this.inpClean.get(curPos).getInt() > 0 && this.inpDVU.get(curPos).getInt() == 0 && this.inpPDP.get(curPos).getInt() == 0;
    }

    private boolean canJustWork(int curPos) {
        if (curPos < 0 || curPos >= this.inpPDP.size()) {
            return false;
        }
        return this.inpWork.get(curPos).getInt() + this.inpClean.get(curPos).getInt() > 0 && this.inpPDP.get(curPos).getInt() == 0;
    }

    private boolean canUseDirection(int curPos) {
        if (curPos < 0 || curPos >= this.inpPDP.size()) {
            return false;
        }
        return this.inpWork.get(curPos).getInt() + this.inpClean.get(curPos).getInt() > 0;
    }

    private void turnOnOut(int iOut) {
        if (iOut < 0) {
            return;
        }
        this.Outs.get(iOut).setInt(1);
    }

    private void turnOffOut(int iOut) {
        if (iOut < 0) {
            return;
        }
        this.Outs.get(iOut).setInt(0);
    }

    private void turnOffOuts() {
        this.iCurOutput = KART_SEQ_NOOUT;
        for (Tag tgOut : this.Outs) {
            tgOut.setInt(0);
        }
        this.tagState.setInt(0);
    }

    private boolean finish() {
        return true;
    }

    private void setBool(Tag tag, boolean value) {
        if (tag.getBool() != value) {
            tag.setBool(value);
        }
    }

    private void setInt(Tag tag, int value) {
        if (tag.getInt() != value) {
            tag.setInt(value);
        }
    }
}

