/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceMDTA
extends Device {
    public static final int FLAG_TRIGGER_ENABLED = 1;
    public static final int FLAG_MCHASOST_MODE = 6;
    public static final int FLAG_NO_DLYOUTPUT = 8;
    public static final int FLAG_DREBEZG_MODE = 48;
    public static final int FLAG_NO_OUTPUT = 64;
    public static final int FLAG_NO_ALARM = 128;
    public static final int FLAG_INVERTED_ALARM = 256;
    public static final int FLAG_ALARM_EQUALS_OUTPUT = 512;
    public static final int FLAG_USE_STATUS = 1024;
    public static final int SOST_OK = 0;
    public static final int SOST_BAD = 1;
    public static final int SOST_OK_OUTPUT = 2;
    public static final int SOST_BAD_OUTPUT = 3;
    public static final int SOST_BAD_BLOK = 4;
    public static final int SOST_BAD_STATUS = 5;
    public static final int SOST_BAD_CHANNEL = 254;
    Input inpTrigRes;
    Input inpMchaSost;
    Tag tagOutput;
    Tag tagSost;
    Tag tagCnt;
    Tag tagValue;
    Tag tagLow;
    Tag tagHigh;
    Tag tagBlok;
    Tag tagDlyDrebezg;
    Tag tagDlyOutputOff;
    Tag tagDlyOutputOn;
    Channel channel;
    Tag tagFlags;
    Tag tagDebugValue;
    Tag tagPointV;
    Tag tagPointP;
    Tag tagPointV1;
    Tag tagPointP1;
    Tag tagPrimeval;
    Tag tagAlarm;
    Tag tagTrigRes;
    int sost;
    boolean val_ok_old;
    int cntDrebezg;
    int cntStart;
    int cntOutputOn;
    int cntOutputOff;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.inpTrigRes = this.getInput("TrigRes", res);
        this.inpMchaSost = this.getInput("MchaSost", res);
        this.tagOutput = this.getOutputTag("Output", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagCnt = this.getOutputTag("Cnt", res);
        this.tagValue = this.getOutputTag("Value", res);
        this.tagLow = this.getOutputTag("Low", res);
        this.tagHigh = this.getOutputTag("High", res);
        this.tagBlok = this.getOutputTag("Blok", res);
        this.tagDlyDrebezg = this.getOutputTag("DlyDrebezg", res);
        this.tagDlyOutputOff = this.getOutputTag("DlyStart", res);
        this.tagDlyOutputOn = this.getOutputTag("DlyOutput", res);
        this.channel = this.createChannel("Channel", Channel.Type.In, res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagDebugValue = this.getOutputTag("DebugValue", res);
        this.tagPointV = this.getOutputTag("PointV", res);
        this.tagPointP = this.getOutputTag("PointP", res);
        this.tagPointV1 = this.getOutputTag("PointV1", res);
        this.tagPointP1 = this.getOutputTag("PointP1", res);
        this.tagPrimeval = this.getOutputTag("Primeval", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagTrigRes = this.getOutputTagOrFake("TrigRes");
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagDebugValue.setInt(65535);
        this.sost = 0;
        this.val_ok_old = true;
        this.cntDrebezg = 0;
        this.cntStart = 0;
        this.cntOutputOn = 0;
        this.cntOutputOff = 0;
    }

    @Override
    public boolean execute() {
        boolean outputAlwaysZero;
        int drebezg_mode;
        boolean val_ok;
        boolean badStatus;
        boolean en_output = false;
        int flags = this.tagFlags.getInt();
        int output = this.tagOutput.getInt();
        if (!this.channel.isOk()) {
            this.tagSost.setInt(254);
            return false;
        }
        int value = this.getTagValue().getInt();
        if (this.tagPointV.getInt() > 0 && this.tagPointP.getInt() > 0 && this.tagPointV.getInt() != this.tagPointP.getInt() && this.tagPointV1.getInt() == 0 && this.tagPointP1.getInt() == 0) {
            value = (int)Math.round(this.getTagValue().getDouble() * this.tagPointV.getDouble() / this.tagPointP.getDouble());
        } else if (this.tagPointV.getInt() > 0 || this.tagPointP.getInt() > 0 || this.tagPointV1.getInt() > 0 || this.tagPointP1.getInt() > 0) {
            double r = 0.0;
            double r1 = this.tagPointP1.getDouble() - this.tagPointP.getDouble();
            double r2 = this.getTagValue().getDouble() - this.tagPointP.getDouble();
            double r3 = this.tagPointV1.getDouble() - this.tagPointV.getDouble();
            if (r1 != 0.0) {
                value = (int)Math.round(r2 / r1 * r3 + this.tagPointV.getDouble());
                if (r < 0.0) {
                    value = 0;
                }
            } else {
                value = 0;
            }
        }
        boolean bl = badStatus = (flags & 0x400) > 0 && this.channel.tagValue.getStatus() != Tag.Status.Good;
        if (badStatus) {
            val_ok = false;
        } else {
            boolean bl2 = val_ok = value >= this.tagLow.getInt() && value <= this.tagHigh.getInt();
        }
        if (val_ok != this.val_ok_old && ((drebezg_mode = flags & 0x30) == 0 && val_ok || drebezg_mode == 16 && this.val_ok_old || drebezg_mode == 48)) {
            this.val_ok_old = val_ok;
        }
        if (val_ok != this.val_ok_old) {
            if (this.cntDrebezg < this.tagDlyDrebezg.getInt()) {
                val_ok = this.val_ok_old;
                ++this.cntDrebezg;
            } else {
                this.val_ok_old = val_ok;
                this.cntDrebezg = 0;
            }
        } else {
            this.cntDrebezg = 0;
        }
        boolean val_bad = !val_ok && !this.tagBlok.getBool();
        int mchasost_val = this.inpMchaSost.getInt();
        int mchaSostMode = flags & 6;
        en_output = mchaSostMode == 0 ? true : (mchaSostMode == 2 ? mchasost_val == 1 : (mchaSostMode == 4 ? mchasost_val == 1 || mchasost_val == 2 : true));
        boolean trr = this.inpTrigRes.tag.getBool() || this.tagTrigRes.getBool() || mchaSostMode > 0 && (mchasost_val == 0 || mchasost_val == 7);
        boolean new_output = false;
        boolean useTrig = (flags & 1) > 0;
        boolean bl3 = outputAlwaysZero = (flags & 0x40) > 0;
        if (output > 0) {
            if (trr || !useTrig && (!val_bad || !en_output)) {
                if (this.cntOutputOff++ >= this.tagDlyOutputOff.getInt()) {
                    output = 0;
                    this.cntOutputOff = 0;
                }
            } else {
                this.cntOutputOff = 0;
            }
        } else {
            if (!trr && val_bad && en_output && !outputAlwaysZero) {
                new_output = true;
            }
            this.cntOutputOff = 0;
        }
        if ((flags & 7) == 5 && !en_output) {
            new_output = false;
        }
        if (new_output) {
            if ((flags & 0xF) == 13 && mchasost_val == 2 && output == 0) {
                this.cntOutputOn = this.tagDlyOutputOn.getInt();
            }
            if (this.cntOutputOn < this.tagDlyOutputOn.getInt()) {
                ++this.cntOutputOn;
            } else {
                output = 1;
                this.cntOutputOn = 0;
            }
        } else {
            this.cntOutputOn = 0;
        }
        this.sost = !this.tagBlok.getBool() && badStatus ? 5 : (this.tagBlok.getBool() && !val_ok ? 4 : (val_bad ? (output > 0 ? 3 : 1) : (output > 0 ? 2 : 0)));
        boolean new_alarm = false;
        if ((flags & 0x200) > 0) {
            new_alarm = output > 0 && (flags & 0x80) == 0;
        } else if ((en_output || output > 0) && (flags & 0x80) == 0) {
            new_alarm = val_bad ^ (flags & 0x100) > 0;
        }
        this.tagAlarm.setBool(new_alarm &= !this.tagBlok.getBool());
        this.tagCnt.setInt(this.cntDrebezg + this.cntOutputOn);
        this.tagOutput.setInt(output);
        this.tagSost.setInt(this.sost);
        this.tagValue.setInt(value);
        this.tagPrimeval.setInt(this.channel.tagValue.getInt());
        this.tagTrigRes.setInt(0);
        return true;
    }

    private Tag getTagValue() {
        if (this.tagDebugValue.getInt() == 65535) {
            return this.channel.tagValue;
        }
        return this.tagDebugValue;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("sost", this.sost);
        state.saveVar("val_ok_old", this.val_ok_old);
        state.saveVar("cntDrebezg", this.cntDrebezg);
        state.saveVar("cntStart", this.cntStart);
        state.saveVar("cntOutputOn", this.cntOutputOn);
        state.saveVar("cntOutputOff", this.cntOutputOff);
    }

    @Override
    public void loadStateExtra(State state) {
        this.sost = state.loadVar("sost", this.sost);
        this.val_ok_old = state.loadVar("val_ok_old", this.val_ok_old);
        this.cntDrebezg = state.loadVar("cntDrebezg", this.cntDrebezg);
        this.cntStart = state.loadVar("cntStart", this.cntStart);
        this.cntOutputOn = state.loadVar("cntOutputOn", this.cntOutputOn);
        this.cntOutputOff = state.loadVar("cntOutputOff", this.cntOutputOff);
    }
}

