/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.List;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.ConnectDevice;
import promauto.jroboplc.plugin.roboplant.Connector;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;

public class DeviceREFA
extends ConnectDevice {
    private static final String CHANNEL_PROVIDER = "channelProvider";
    private static final String CHANNEL_PROVIDER_IN = "channelProviderIn";
    private static final String CHANNEL_PROVIDER_OUT = "channelProviderOut";
    private static final String CHANNEL_PROVIDER_INOUT = "channelProviderInOut";
    private static final String EXECUTE_BIND_MODULE = "executeBindModule";
    private List<Input> inpInput = new ArrayList<Input>();
    private List<Output> tagOutput = new ArrayList<Output>();
    private Output outputExecuteBindModule;

    @Override
    public void prepareTags(Device.RefBool res) {
        boolean need_create_tags = false;
        for (Input input : this.inputs) {
            if (input.isEmpty()) continue;
            Output output = this.getOutput(input.name);
            if (output == null) {
                output = new Output();
                output.name = input.name;
                output.num = -1;
                output.access_readonly = false;
                this.outputs.add(output);
                need_create_tags = true;
            }
            this.inpInput.add(input);
            this.tagOutput.add(output);
        }
        if (need_create_tags) {
            this.createTagForEachOutputs();
            this.sortInputOutputArrays();
        }
        for (Output output : this.outputs) {
            if (output.name.startsWith(CHANNEL_PROVIDER) || output.name.equals(EXECUTE_BIND_MODULE)) continue;
            this.connector.connect(output.name, output.name, output.access_readonly ? Connector.Mode.READ : Connector.Mode.WRITE, res);
        }
        if (this.getOutput(CHANNEL_PROVIDER_IN) != null) {
            this.registerAsChannelProvider(CHANNEL_PROVIDER_IN, Channel.Type.In, res);
        } else if (this.getOutput(CHANNEL_PROVIDER_OUT) != null) {
            this.registerAsChannelProvider(CHANNEL_PROVIDER_OUT, Channel.Type.Out, res);
        } else if (this.getOutput(CHANNEL_PROVIDER_INOUT) != null) {
            this.registerAsChannelProvider(CHANNEL_PROVIDER_INOUT, Channel.Type.InOut, res);
        }
        this.outputExecuteBindModule = this.getOutput(EXECUTE_BIND_MODULE);
    }

    @Override
    public boolean execute() {
        for (int i = 0; i < this.inpInput.size(); ++i) {
            this.tagOutput.get((int)i).tag.setInt(this.inpInput.get(i).getInt());
        }
        super.execute();
        if (this.outputExecuteBindModule != null && this.outputExecuteBindModule.tag.getBool() && this.connector.getBindmod() != null) {
            this.connector.getBindmod().execute();
            super.execute();
        }
        return true;
    }
}

