/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.time.LocalDateTime;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceSTATA
extends Device {
    protected Input inpInput;
    protected Tag tagCount;
    protected Tag tagBegDate;
    protected Tag tagBegTime;
    protected Tag tagTimeTotal;
    protected Tag tagTimeCur;
    protected Tag tagMin;
    protected Tag tagMax;
    protected Tag tagDiv;
    protected Tag tagFlags;
    protected static final int TIMES_SIZE = 200;
    protected Time[] times = new Time[200];
    int startdate;
    int starttime;
    long startms;
    long lastms;
    int lastinp;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpInput = this.getInput("Input", res);
        this.tagCount = this.getOutputTag("Count", res);
        this.tagBegDate = this.getOutputTag("BegDate", res);
        this.tagBegTime = this.getOutputTag("BegTime", res);
        this.tagTimeTotal = this.getOutputTag("TimeTotal", res);
        this.tagTimeCur = this.getOutputTag("TimeCur", res);
        this.tagMin = this.getOutputTag("Min", res);
        this.tagMax = this.getOutputTag("Max", res);
        this.tagDiv = this.getOutputTag("Div", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        for (int i = 0; i < 200; ++i) {
            this.times[i] = new Time();
            this.times[i].tag = this.getOutputTag("Time_" + i, res);
            this.times[i].value = 0L;
        }
        this.startms = 0L;
        this.lastms = 0L;
        this.lastinp = 0;
    }

    @Override
    public boolean execute() {
        int input = this.inpInput.getInt();
        int min = this.tagMin.getInt();
        int max = this.tagMax.getInt();
        if (min < 0) {
            min = 0;
            this.tagMin.setInt(0);
        }
        if (max >= 200) {
            max = 199;
            this.tagMin.setInt(199);
        }
        if (this.lastms != 0L) {
            int div;
            long curms = System.currentTimeMillis();
            int n = div = this.tagDiv.getInt() <= 0 ? 1000 : this.tagDiv.getInt();
            if (this.lastinp != input) {
                this.times[this.lastinp].value += curms - this.lastms;
                this.lastms = curms;
            } else {
                this.tagTimeCur.setInt((int)Math.round((double)(curms - this.lastms) / (double)div));
            }
            if (input < min || input > max || input == min && input < this.lastinp) {
                for (Time time : this.times) {
                    time.tag.setInt((int)Math.round((double)time.value / (double)div));
                    time.value = 0L;
                }
                this.tagBegDate.setInt(this.startdate);
                this.tagBegTime.setInt(this.starttime);
                this.tagTimeTotal.setInt((int)Math.round((double)(this.lastms - this.startms) / (double)div));
                this.tagCount.setInt(this.tagCount.getInt() + 1);
                this.tagTimeCur.setInt(0);
                this.lastms = 0L;
            }
        } else if (input >= min && input <= max) {
            this.lastms = this.startms = System.currentTimeMillis();
            LocalDateTime ldt = LocalDateTime.now();
            this.startdate = ldt.getYear() * 10000 + ldt.getMonth().getValue() * 100 + ldt.getDayOfMonth();
            this.starttime = ldt.getHour() * 10000 + ldt.getMinute() * 100 + ldt.getSecond();
        }
        this.lastinp = input;
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("startms", this.startms);
        state.saveVar("lastms", this.lastms);
        state.saveVar("lastinp", this.lastinp);
        state.saveVar("startdate", this.startdate);
        state.saveVar("starttime", this.starttime);
        for (int i = 0; i < 200; ++i) {
            state.saveVar("value_" + i, this.times[i].value);
        }
    }

    @Override
    public void loadStateExtra(State state) {
        this.startms = state.loadVar("startms", this.startms);
        this.lastms = state.loadVar("lastms", this.lastms);
        this.lastinp = state.loadVar("lastinp", this.lastinp);
        this.startdate = state.loadVar("startdate", this.startdate);
        this.starttime = state.loadVar("starttime", this.starttime);
        for (int i = 0; i < 200; ++i) {
            this.times[i].value = state.loadVar("value_" + i, this.times[i].value);
        }
    }

    protected static final class Time {
        Tag tag;
        long value;

        protected Time() {
        }
    }
}

