/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceSTMC
extends Device {
    protected static final int STATE_OFF = 0;
    protected static final int STATE_START_DLY = 1;
    protected static final int STATE_BEFORE_LOAD = 2;
    protected static final int STATE_LOAD_OPEN = 3;
    protected static final int STATE_LOAD_DLY = 4;
    protected static final int STATE_WARM_PREPARE = 5;
    protected static final int STATE_WARM = 6;
    protected static final int STATE_INFLATE = 7;
    protected static final int STATE_INFLATE_FINISH = 8;
    protected static final int STATE_EXPOSITION_INFL = 10;
    protected static final int STATE_EXPOSITION = 11;
    protected static final int STATE_DEFLATE = 12;
    protected static final int STATE_UNLOAD_OPEN = 13;
    protected static final int STATE_UNLOAD_DLY = 14;
    protected static final int STATE_BLOW_PREPARE = 15;
    protected static final int STATE_BLOW_INFLATE = 16;
    protected static final int STATE_BLOW_K2_DLY = 19;
    protected static final int STATE_BLOW_K2_CLOSE = 20;
    protected static final int STATE_CYCLE_PAUSE = 21;
    private static List<Integer> stateseq = new ArrayList<Integer>();
    protected static final int WAIT_TIMER = 1;
    protected static final int WAIT_DVU1 = 2;
    protected static final int WAIT_DVU2 = 4;
    protected static final int WAIT_PLINE = 8;
    protected static final int WAIT_PWORK = 16;
    protected static final int WAIT_PLOAD = 32;
    protected static final int WAIT_PUNLOAD = 64;
    protected static final int WAIT_NEIGHBOUR = 128;
    private static final int NCL = 1;
    private static final int CLS = 2;
    private static final int NOP = 3;
    private static final int OPN = 4;
    private static final int ALARM_INFLATE_TIMEOUT = 1;
    private static final int ALARM_PALARM = 2;
    private static final int ALARM_PDIR = 3;
    Input inpEnable;
    Input inpSuspend;
    Input inpP;
    Input inpPEmrg;
    Input inpPLineHigh;
    Input inpNbState;
    Input inpDVU1;
    Input inpDVU2;
    Input inpClosedK1;
    Input inpClosedK2;
    Input inpClosedK3;
    Input inpClosedK4;
    Input inpClosedK5;
    Input inpClosedK6;
    Input inpClosedK7;
    Input inpClosedK8;
    Input inpOpenedK1;
    Input inpOpenedK2;
    Tag tagState;
    Tag tagWaitCl;
    Tag tagWaitOp;
    Tag tagWaitEx;
    Tag tagAlarm;
    Tag tagTimer;
    Tag tagCycleNum;
    Tag tagBlowNum;
    Tag tagOpenK1;
    Tag tagOpenK2;
    Tag tagOpenK3;
    Tag tagOpenK4;
    Tag tagOpenK5;
    Tag tagOpenK6;
    Tag tagFullK6;
    Tag tagOpenK7;
    Tag tagOpenK8;
    Tag tagBtnStart;
    Tag tagBtnStop;
    Tag tagNextState;
    Tag tagFlags;
    Tag tagCycleQnt;
    Tag tagPAlarm;
    Tag tagPWork;
    Tag tagPWorkMax;
    Tag tagPDeair;
    Tag tagPDelta;
    Tag tagPDeltaMax;
    Tag tagPOpenK6;
    Tag tagPOpenK5;
    Tag tagPLoad;
    Tag tagPUnload;
    Tag tagTimeBlowInfl;
    Tag tagTimeStartDly;
    Tag tagTimeLoad;
    Tag tagTimeWarm;
    Tag tagTimeInflMax;
    Tag tagTimeExp;
    Tag tagTimeExpMax;
    Tag tagTimeUnload;
    Tag tagTimeUnloadMin;
    Tag tagTimeBlow;
    Tag tagTimeCycDly;
    Tag tagBlowQnt;
    Tag tagBlowQntMax;
    Tag tagTimeNoExpInfl;
    Tag tagSuspend;
    private int state;
    private int stateidx;
    private int waitCl;
    private int waitOp;
    private int waitEx;
    private int alarm;
    private int timer;
    private int openK1;
    private int openK2;
    private int openK3;
    private int openK4;
    private int openK5;
    private int openK6;
    private int fullK6;
    private int openK7;
    private int openK8;
    private int openK9;
    private int pdirK;
    private int pdirValue;
    private boolean pdirAlarm;
    private int pdirTimer;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpEnable = this.getInput("Enable", res);
        this.inpSuspend = this.getInput("Suspend", res);
        this.inpP = this.getInput("P", res);
        this.inpPEmrg = this.getInput("PEmrg", res);
        this.inpPLineHigh = this.getInput("PLineHigh", res);
        this.inpNbState = this.getInput("NbState", res);
        this.inpDVU1 = this.getInput("DVU1", res);
        this.inpDVU2 = this.getInput("DVU2", res);
        this.inpClosedK1 = this.getInput("ClosedK1", res);
        this.inpOpenedK1 = this.getInput("OpenedK1", res);
        this.inpClosedK2 = this.getInput("ClosedK2", res);
        this.inpOpenedK2 = this.getInput("OpenedK2", res);
        this.inpClosedK3 = this.getInput("ClosedK3", res);
        this.inpClosedK4 = this.getInput("ClosedK4", res);
        this.inpClosedK5 = this.getInput("ClosedK5", res);
        this.inpClosedK6 = this.getInput("ClosedK6", res);
        this.inpClosedK7 = this.getInput("ClosedK7", res);
        this.inpClosedK8 = this.getInput("ClosedK8", res);
        this.tagState = this.getOutputTag("State", res);
        this.tagWaitCl = this.getOutputTag("WaitCl", res);
        this.tagWaitOp = this.getOutputTag("WaitOp", res);
        this.tagWaitEx = this.getOutputTag("WaitEx", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagTimer = this.getOutputTag("Timer", res);
        this.tagCycleNum = this.getOutputTag("CycleNum", res);
        this.tagBlowNum = this.getOutputTag("BlowNum", res);
        this.tagOpenK1 = this.getOutputTag("OpenK1", res);
        this.tagOpenK2 = this.getOutputTag("OpenK2", res);
        this.tagOpenK3 = this.getOutputTag("OpenK3", res);
        this.tagOpenK4 = this.getOutputTag("OpenK4", res);
        this.tagOpenK5 = this.getOutputTag("OpenK5", res);
        this.tagOpenK6 = this.getOutputTag("OpenK6", res);
        this.tagFullK6 = this.getOutputTag("FullK6", res);
        this.tagOpenK7 = this.getOutputTag("OpenK7", res);
        this.tagOpenK8 = this.getOutputTag("OpenK8", res);
        this.tagBtnStart = this.getOutputTag("BtnStart", res);
        this.tagBtnStop = this.getOutputTag("BtnStop", res);
        this.tagNextState = this.getOutputTag("NextState", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagCycleQnt = this.getOutputTag("CycleQnt", res);
        this.tagPAlarm = this.getOutputTag("PAlarm", res);
        this.tagPWork = this.getOutputTag("PWork", res);
        this.tagPWorkMax = this.getOutputTag("PWorkMax", res);
        this.tagPDeair = this.getOutputTag("PDeair", res);
        this.tagPDelta = this.getOutputTag("PDelta", res);
        this.tagPDeltaMax = this.getOutputTag("PDeltaMax", res);
        this.tagPOpenK6 = this.getOutputTag("POpenK6", res);
        this.tagPOpenK5 = this.getOutputTag("POpenK5", res);
        this.tagPLoad = this.getOutputTag("PLoad", res);
        this.tagPUnload = this.getOutputTag("PUnload", res);
        this.tagTimeBlowInfl = this.getOutputTag("TimeBlowInfl", res);
        this.tagTimeStartDly = this.getOutputTag("TimeStartDly", res);
        this.tagTimeLoad = this.getOutputTag("TimeLoad", res);
        this.tagTimeWarm = this.getOutputTag("TimeWarm", res);
        this.tagTimeInflMax = this.getOutputTag("TimeInflMax", res);
        this.tagTimeExp = this.getOutputTag("TimeExp", res);
        this.tagTimeExpMax = this.getOutputTag("TimeExpMax", res);
        this.tagTimeUnload = this.getOutputTag("TimeUnload", res);
        this.tagTimeUnloadMin = this.getOutputTag("TimeUnloadMin", res);
        this.tagTimeBlow = this.getOutputTag("TimeBlow", res);
        this.tagTimeCycDly = this.getOutputTag("TimeCycDly", res);
        this.tagBlowQnt = this.getOutputTag("BlowQnt", res);
        this.tagBlowQntMax = this.getOutputTag("BlowQntMax", res);
        this.tagTimeNoExpInfl = this.getOutputTag("TimeNoExpInfl", res);
        this.tagSuspend = this.getOutputTag("Suspend", res);
        this.state = 0;
        this.stateidx = 0;
        this.waitCl = 0;
        this.waitOp = 0;
        this.waitEx = 0;
        this.alarm = 0;
        this.timer = 0;
        this.openK1 = 0;
        this.openK2 = 0;
        this.openK3 = 0;
        this.openK4 = 0;
        this.openK5 = 0;
        this.openK6 = 0;
        this.fullK6 = 0;
        this.openK7 = 0;
        this.openK8 = 0;
        this.openK9 = 0;
        this.pdirK = 0;
        this.pdirValue = 0;
        this.pdirAlarm = false;
        this.pdirTimer = 0;
    }

    @Override
    public boolean execute() {
        this.makeConsistency();
        if (this.tagSuspend.getInt() == 0) {
            this.updateTimer();
        }
        this.waitCl = 0;
        this.waitOp = 0;
        this.waitEx = 0;
        this.alarm = 0;
        if (this.tagNextState.getInt() > 0) {
            if (this.state > 0 && this.tagNextState.getInt() == 777) {
                this.nextState();
                this.resetTimer();
            }
            this.tagNextState.setInt(0);
        }
        if (this.state == 0) {
            this.setValves(0, 0, 0, 0, 0, 0, 0, 0);
            this.tagBtnStop.setInt(0);
            if (this.tagBtnStart.getBool()) {
                this.nextState();
                this.resetLast();
            }
        }
        this.tagBtnStart.setInt(0);
        if (this.tagSuspend.getBool() && this.tagBtnStop.getBool()) {
            this.setState(0);
            this.resetTimer();
        }
        if (this.tagSuspend.getInt() == 0) {
            if (this.state == 1) {
                this.setValves(0, 0, 0, 0, 0, 0, 0, 0);
                if (this.tagBtnStop.getBool()) {
                    this.setState(0);
                    this.resetTimer();
                } else {
                    this.useTimer(this.tagTimeStartDly);
                    this.nextStateIfChecked();
                }
            }
            if (this.state == 2) {
                if (this.tagBtnStop.getBool()) {
                    this.setState(0);
                } else {
                    this.setValves(0, 0, 0, 0, 1, 0, 0, 0);
                    this.chkValves(2, 2, 2, 2, 1, 2, 2, 2);
                    this.chkEx(8, this.inpPLineHigh.getInt() > 0);
                    this.chkEx(32, this.inpP.getInt() <= this.tagPLoad.getInt());
                    this.chkEx(2, this.inpDVU1.getInt() > 0);
                    this.chkEx(4, this.inpDVU2.getInt() == 0);
                    this.chkEx(128, this.inpNbState.getInt() < 3 || this.inpNbState.getInt() > 7);
                    this.nextStateIfChecked();
                }
            }
            if (this.state == 3) {
                this.setValves(1, 0, 0, 0, 1, 0, 0, 0);
                this.chkValves(1, 0, 0, 0, 0, 0, 0, 0);
                this.nextStateIfChecked();
            }
            if (this.state == 4) {
                this.setValves(1, 0, 0, 0, 1, 0, 0, 0);
                this.useTimer(this.tagTimeLoad);
                this.nextStateIfChecked();
            }
            if (this.state == 5) {
                this.setValves(0, 0, 0, 0, 1, 0, 0, 0);
                this.chkValves(2, 2, 2, 2, 1, 2, 2, 2);
                this.chkEx(8, this.inpPLineHigh.getInt() > 0);
                this.chkEx(128, this.inpNbState.getInt() != 6 && this.inpNbState.getInt() != 7 && this.inpNbState.getInt() != 10 && this.inpNbState.getInt() != 16);
                this.nextStateIfChecked();
            }
            if (this.state == 6) {
                this.setValves(0, 0, 0, 1, 1, 0, 0, 1);
                if (this.inpNbState.getInt() == 10 || this.inpNbState.getInt() == 16) {
                    this.openK4 = 0;
                }
                this.useTimer(this.tagTimeWarm);
                if (this.nextStateIfChecked()) {
                    this.resetTimer();
                    this.setupTimer(this.tagTimeInflMax);
                }
            }
            if (this.state == 7) {
                this.setValves(0, 0, 0, 1, 0, 0, 0, 1);
                if (this.inpNbState.getInt() == 10 || this.inpNbState.getInt() == 16) {
                    this.openK4 = 0;
                }
                this.chkEx(16, this.inpP.getInt() >= this.tagPWork.getInt());
                this.nextStateIfChecked();
                if (this.timer <= 0 && !this.checked()) {
                    this.alarm = 1;
                }
            }
            if (this.state == 8) {
                this.resetTimer();
                this.setValves(0, 0, 0, 0, 0, 0, 0, 1);
                this.chkValves(2, 2, 2, 2, 2, 2, 2, 1);
                this.nextStateIfChecked();
            }
            if (this.state == 10) {
                if (this.isTimerOff()) {
                    this.nextState();
                } else {
                    this.setValves(0, 0, 0, 1, 0, 0, 0, 1);
                    this.chkEx(16, this.inpP.getInt() >= this.tagPWork.getInt());
                    this.nextStateIfChecked();
                }
            }
            if (this.state == 11) {
                this.setValves(0, 0, 0, 0, 0, 0, 0, 1);
                this.useTimer(this.tagTimeExp);
                if (!this.nextStateIfChecked() && this.inpP.getInt() <= this.tagPWork.getInt() - this.tagPDelta.getInt() && this.timer > this.tagTimeNoExpInfl.getInt()) {
                    this.setState(10);
                    this.openK4 = 1;
                }
            }
            if (this.state == 12) {
                this.setValves(0, 0, 0, 0, 1, 1, 0, 1);
                this.chkEx(64, this.inpP.getInt() <= this.tagPUnload.getInt());
                this.nextStateIfChecked();
            }
            if (this.state == 13) {
                this.setValves(0, 1, 0, 0, 1, 1, 0, 1);
                this.chkValves(0, 1, 0, 0, 0, 0, 0, 0);
                this.nextStateIfChecked();
            }
            if (this.state == 14) {
                this.setValves(0, 1, 0, 0, 1, 0, 0, 1);
                this.useTimer(this.tagTimeUnload);
                this.nextStateIfChecked();
            }
            if (this.state == 15) {
                this.tagBlowNum.setInt(0);
                this.setValves(0, 1, 0, 0, 0, 0, 0, 0);
                this.chkValves(2, 1, 2, 2, 2, 2, 2, 2);
                this.nextStateIfChecked();
            }
            if (this.state == 16) {
                if (this.tagBlowNum.getInt() >= this.tagBlowQnt.getInt()) {
                    this.setState(20);
                } else {
                    this.setValves(0, 1, 0, 1, 0, 0, 1, 0);
                    this.useTimer(this.tagTimeBlowInfl);
                    if (this.nextStateIfChecked()) {
                        this.resetTimer();
                    }
                }
            }
            if (this.state == 19) {
                this.setValves(0, 1, 0, 0, 0, 0, 0, 0);
                this.useTimer(this.tagTimeBlow);
                this.nextStateIfChecked();
            }
            if (this.state == 20) {
                this.setValves(0, 1, 0, 0, 0, 0, 0, 0);
                this.chkValves(2, 1, 2, 2, 2, 2, 2, 2);
                if (this.checked()) {
                    this.tagBlowNum.setInt(this.tagBlowNum.getInt() + 1);
                    if (this.tagBlowNum.getInt() >= this.tagBlowQnt.getInt()) {
                        this.setState(21);
                    } else {
                        this.setState(16);
                    }
                }
                this.resetTimer();
            }
            if (this.state == 21) {
                if (this.tagTimeCycDly.getInt() <= 0) {
                    this.tagTimeCycDly.setInt(2);
                }
                this.setValves(0, 0, 0, 0, 0, 0, 0, 0);
                this.useTimer(this.tagTimeCycDly);
                if (this.checked()) {
                    this.setState(2);
                    this.tagCycleNum.setInt(this.tagCycleNum.getInt() + 1);
                    if (this.tagCycleQnt.getInt() > 0) {
                        this.tagCycleQnt.setInt(this.tagCycleQnt.getInt() - 1);
                        if (this.tagCycleQnt.getInt() <= 0) {
                            this.setState(0);
                        }
                    }
                    if (this.tagBtnStop.getBool()) {
                        this.setState(0);
                    }
                    this.tagBlowNum.setInt(0);
                    this.copyLast();
                    this.resetLast();
                }
            }
        }
        this.openK5 = this.openK5 > 0 && (this.inpP.getInt() <= this.tagPOpenK5.getInt() || this.state == 6) ? 1 : 0;
        int n = this.fullK6 = this.openK6 > 0 && this.inpP.getInt() <= this.tagPOpenK6.getInt() ? 1 : 0;
        if (this.inpPEmrg.getInt() > 0 || this.inpClosedK1.getInt() == 0 || this.inpClosedK2.getInt() == 0 && this.state != 16) {
            this.openK4 = 0;
            this.openK3 = 0;
        }
        if (this.inpP.getInt() >= this.tagPAlarm.getInt()) {
            this.alarm = 2;
        }
        if (this.inpP.getInt() < this.pdirValue) {
            this.pdirK = -1;
        } else if (this.inpP.getInt() > this.pdirValue) {
            this.pdirK = 1;
        }
        this.pdirValue = this.inpP.getInt();
        if (this.state == 7) {
            if (!this.pdirAlarm) {
                if (this.pdirK < 0) {
                    if (this.pdirTimer >= this.tagPDeair.getInt()) {
                        this.pdirAlarm = true;
                    } else {
                        ++this.pdirTimer;
                    }
                } else {
                    this.pdirTimer = 0;
                }
            }
            if (this.pdirAlarm) {
                this.alarm = 3;
                this.openK4 = 0;
                this.openK3 = 0;
            }
        } else {
            this.pdirTimer = 0;
            this.pdirAlarm = false;
            this.pdirK = 0;
        }
        this.tagState.setInt(this.state);
        this.tagWaitCl.setInt(this.waitCl);
        this.tagWaitOp.setInt(this.waitOp);
        this.tagWaitEx.setInt(this.waitEx);
        this.tagAlarm.setInt(this.alarm);
        this.tagTimer.setInt(this.timer);
        this.tagOpenK1.setInt(this.openK1);
        this.tagOpenK2.setInt(this.openK2);
        this.tagOpenK3.setInt(this.openK3);
        this.tagOpenK4.setInt(this.openK4);
        this.tagOpenK5.setInt(this.openK5);
        this.tagOpenK6.setInt(this.openK6);
        this.tagFullK6.setInt(this.fullK6);
        this.tagOpenK7.setInt(this.openK7);
        this.tagOpenK8.setInt(this.openK8);
        return true;
    }

    private void resetLast() {
    }

    private void copyLast() {
    }

    private void makeConsistency() {
        if (this.tagPWork.getInt() > this.tagPWorkMax.getInt()) {
            this.tagPWork.setInt(this.tagPWorkMax.getInt());
        }
        if (this.tagPDelta.getInt() > this.tagPDeltaMax.getInt()) {
            this.tagPDelta.setInt(this.tagPDeltaMax.getInt());
        }
        if (this.tagTimeExp.getInt() > this.tagTimeExpMax.getInt()) {
            this.tagTimeExp.setInt(this.tagTimeExpMax.getInt());
        }
        if (this.tagTimeUnload.getInt() < this.tagTimeUnloadMin.getInt()) {
            this.tagTimeUnload.setInt(this.tagTimeUnloadMin.getInt());
        }
        if (this.tagBlowQnt.getInt() > this.tagBlowQntMax.getInt()) {
            this.tagBlowQnt.setInt(this.tagBlowQntMax.getInt());
        }
    }

    private void useTimer(Tag time) {
        this.setupTimer(time);
        this.chkEx(1, this.timer <= 0);
    }

    private boolean isTimerOff() {
        return this.timer <= 0;
    }

    private void setupTimer(Tag time) {
        if (this.timer < 0) {
            this.timer = time.getInt();
        }
    }

    private void updateTimer() {
        if (this.timer >= 0) {
            --this.timer;
        }
    }

    private void resetTimer() {
        this.timer = -1;
    }

    private void setState(int newstate) {
        for (int i = 0; i < stateseq.size(); ++i) {
            if (stateseq.get(i) != newstate) continue;
            this.stateidx = i;
            break;
        }
        this.state = stateseq.get(this.stateidx);
    }

    private void nextState() {
        ++this.stateidx;
        if (this.stateidx >= 0 && this.stateidx < stateseq.size()) {
            this.state = stateseq.get(this.stateidx);
        } else {
            this.setState(0);
        }
    }

    private boolean nextStateIfChecked() {
        if (this.checked()) {
            this.nextState();
            return true;
        }
        return false;
    }

    private boolean checked() {
        return (this.waitCl | this.waitOp | this.waitEx) == 0;
    }

    private void setValves(int k1, int k2, int k3, int k4, int k5, int k6, int k7, int k8) {
        this.openK1 = k1;
        this.openK2 = k2;
        this.openK3 = k3;
        this.openK4 = k4;
        this.openK5 = k5;
        this.openK6 = k6;
        this.openK7 = k7;
        this.openK8 = k8;
    }

    private void chkValves(int k1, int k2, int k3, int k4, int k5, int k6, int k7, int k8) {
        this.chkValve(0, k1, this.inpClosedK1, this.inpOpenedK1);
        this.chkValve(1, k2, this.inpClosedK2, this.inpOpenedK2);
        this.chkValve(2, k3, this.inpClosedK3);
        this.chkValve(3, k4, this.inpClosedK4);
        this.chkValve(4, k5, this.inpClosedK5);
        this.chkValve(5, k6, this.inpClosedK6);
        this.chkValve(6, k7, this.inpClosedK7);
        this.chkValve(7, k8, this.inpClosedK8);
    }

    private boolean chkValve(int bit, int mode, Input inp) {
        if (mode == 1 && inp.getInt() > 0) {
            this.waitCl += 1 << bit;
        } else if (mode == 2 && inp.getInt() <= 0) {
            this.waitCl += 1 << bit + 8;
        } else {
            return true;
        }
        return false;
    }

    private boolean chkValve(int bit, int mode, Input inpClosed, Input inpOpened) {
        if (!this.chkValve(bit, mode, inpClosed)) {
            return false;
        }
        if (mode == 3 && inpOpened.getInt() > 0) {
            this.waitOp += 1 << bit;
        } else if (mode == 4 && inpOpened.getInt() <= 0) {
            this.waitOp += 1 << bit + 8;
        } else {
            return true;
        }
        return false;
    }

    private boolean chkEx(int waitMask, boolean is_ok) {
        if (!is_ok) {
            this.waitEx += waitMask;
            return false;
        }
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("state", this.state);
        state.saveVar("stateidx", this.stateidx);
        state.saveVar("waitCl", this.waitCl);
        state.saveVar("waitOp", this.waitOp);
        state.saveVar("waitEx", this.waitEx);
        state.saveVar("alarm", this.alarm);
        state.saveVar("timer", this.timer);
        state.saveVar("openK1", this.openK1);
        state.saveVar("openK2", this.openK2);
        state.saveVar("openK3", this.openK3);
        state.saveVar("openK4", this.openK4);
        state.saveVar("openK5", this.openK5);
        state.saveVar("openK6", this.openK6);
        state.saveVar("fullK6", this.fullK6);
        state.saveVar("openK7", this.openK7);
        state.saveVar("openK8", this.openK8);
        state.saveVar("openK9", this.openK9);
        state.saveVar("pdirValue", this.pdirValue);
        state.saveVar("pdirAlarm", this.pdirAlarm);
        state.saveVar("pdirK", this.pdirK);
        state.saveVar("pdirTimer", this.pdirTimer);
    }

    @Override
    public void loadStateExtra(State state) {
        this.state = state.loadVar("state", this.state);
        this.stateidx = state.loadVar("stateidx", this.stateidx);
        this.waitCl = state.loadVar("waitCl", this.waitCl);
        this.waitOp = state.loadVar("waitOp", this.waitOp);
        this.waitEx = state.loadVar("waitEx", this.waitEx);
        this.alarm = state.loadVar("alarm", this.alarm);
        this.timer = state.loadVar("timer", this.timer);
        this.openK1 = state.loadVar("openK1", this.openK1);
        this.openK2 = state.loadVar("openK2", this.openK2);
        this.openK3 = state.loadVar("openK3", this.openK3);
        this.openK4 = state.loadVar("openK4", this.openK4);
        this.openK5 = state.loadVar("openK5", this.openK5);
        this.openK6 = state.loadVar("openK6", this.openK6);
        this.fullK6 = state.loadVar("fullK6", this.fullK6);
        this.openK7 = state.loadVar("openK7", this.openK7);
        this.openK8 = state.loadVar("openK8", this.openK8);
        this.openK9 = state.loadVar("openK9", this.openK9);
        this.pdirValue = state.loadVar("pdirValue", this.pdirValue);
        this.pdirTimer = state.loadVar("pdirTimer", this.pdirTimer);
        this.pdirAlarm = state.loadVar("pdirAlarm", this.pdirAlarm);
        this.pdirK = state.loadVar("pdirK", this.pdirK);
    }

    static {
        stateseq.add(0);
        stateseq.add(1);
        stateseq.add(2);
        stateseq.add(3);
        stateseq.add(4);
        stateseq.add(5);
        stateseq.add(6);
        stateseq.add(7);
        stateseq.add(8);
        stateseq.add(10);
        stateseq.add(11);
        stateseq.add(12);
        stateseq.add(13);
        stateseq.add(14);
        stateseq.add(15);
        stateseq.add(16);
        stateseq.add(19);
        stateseq.add(20);
        stateseq.add(21);
    }
}

