/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.Action;
import promauto.jroboplc.plugin.script.ScriptJava;
import promauto.jroboplc.plugin.script.ScriptModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class ActionScriptJava
extends Action {
    private final Logger logger = LoggerFactory.getLogger(ActionScriptJava.class);
    public static final String IMPORTS = "import promauto.jroboplc.plugin.script.ScriptJava;\r\nimport promauto.jroboplc.core.tags.*;\r\nimport promauto.jroboplc.core.api.*;\r\n";
    private final Environment env;
    private final ScriptModule module;
    protected ScriptJava instance;
    protected List<Ref> refs = null;
    protected List<Tag> vars = null;
    private boolean valid;

    public ActionScriptJava(ScriptModule module) {
        this.module = module;
        this.env = EnvironmentInst.get();
    }

    @Override
    public boolean load(Object conf) {
        super.load(conf);
        Configuration cm = this.env.getConfiguration();
        Class<?> cls = this.getJavaClass(cm.get(conf, "class", ""));
        if (cls == null) {
            return false;
        }
        boolean res = false;
        try {
            this.instance = (ScriptJava)cls.newInstance();
            res = this.instance.load(this.module, this, conf);
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName(), "Id:", this.getId());
        }
        return res;
    }

    @Override
    public boolean prepare() {
        try {
            if (this.instance.prepare()) {
                if (this.refs != null) {
                    for (Ref ref : this.refs) {
                        if (!ref.prepare()) break;
                        ref.link();
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName(), "Id:", this.getId());
        }
        return false;
    }

    @Override
    public void execute() {
        boolean flag = true;
        if (this.refs != null) {
            for (Ref ref : this.refs) {
                if (ref.linkIfNotValid()) continue;
                flag = false;
            }
        }
        this.valid = flag;
        try {
            this.instance.execute();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName(), "Id:", this.getId());
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getError() {
        StringBuilder res = new StringBuilder("java " + this.getId() + ": ");
        if (this.refs != null) {
            for (Ref ref : this.refs) {
                if (ref.isValid()) continue;
                res.append(ref.getName()).append(" ");
            }
        }
        return res.toString();
    }

    protected void addRef(Ref ref) {
        if (this.refs == null) {
            this.refs = new LinkedList<Ref>();
        }
        this.refs.add(ref);
    }

    protected Tag addVar(Tag tag) {
        if (this.vars == null) {
            this.vars = new LinkedList<Tag>();
        }
        this.vars.add(tag);
        return tag;
    }

    @Override
    public void saveState(Map<String, String> state) {
        if (this.vars != null) {
            this.vars.forEach(tag -> state.put(tag.getName(), tag.getString()));
        }
    }

    @Override
    public void loadState(Map<String, String> state) {
        if (this.vars != null) {
            for (Tag tag : this.vars) {
                String value = state.get(tag.getName());
                if (value == null) continue;
                tag.setString(value);
            }
        }
    }

    protected Class<?> getJavaClass(String javaClassName) {
        Class<?> cls = null;
        try {
            cls = Class.forName("promauto.jroboplc.plugin.script." + javaClassName);
            this.module.javaClasses.put(javaClassName, cls);
            return cls;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                cls = Class.forName("promauto.jroboplc.plugin.script.samples." + javaClassName);
                this.module.javaClasses.put(javaClassName, cls);
                return cls;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    cls = Class.forName("promauto.jroboplc.plugin.script.utils." + javaClassName);
                    this.module.javaClasses.put(javaClassName, cls);
                    return cls;
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    try {
                        if (javaClassName.isEmpty()) {
                            this.env.printError(this.logger, this.module.getName(), "Class name is empty");
                            return null;
                        }
                        cls = this.module.javaClasses.get(javaClassName);
                        if (cls != null) {
                            return cls;
                        }
                        String fname = javaClassName.replaceAll("\\.", "/");
                        Path pathBinClass = this.module.javaDirBin.resolve(fname + ".class");
                        Path pathBinHash = this.module.javaDirBin.resolve(fname + ".hash");
                        Path pathBinSrc = this.module.javaDirBin.resolve(fname + ".java");
                        Path pathSrc = this.module.javaDirSrc.resolve(fname + ".java");
                        if (!Files.exists(pathSrc, new LinkOption[0])) {
                            this.env.printError(this.logger, this.module.getName(), "Source not found:", javaClassName);
                            return null;
                        }
                        String header = this.constructHeader(javaClassName);
                        if (!this.checkJavaHash(header, pathSrc, pathBinClass, pathBinHash)) {
                            if (this.module.javaCompiler == null && (this.module.javaCompiler = ToolProvider.getSystemJavaCompiler()) == null) {
                                this.env.printError(this.logger, this.module.getName(), "Java compiler not found");
                                return null;
                            }
                            if (!this.constructBinSource(header, pathSrc, pathBinSrc)) {
                                return null;
                            }
                            ArrayList<String> options = new ArrayList<String>();
                            options.add("-Xlint:all");
                            options.add("-encoding");
                            options.add("utf8");
                            options.add(pathBinSrc.toString());
                            ByteArrayOutputStream sout = new ByteArrayOutputStream();
                            ByteArrayOutputStream serr = new ByteArrayOutputStream();
                            if (this.module.javaCompiler.run(null, sout, serr, options.toArray(new String[options.size()])) != 0) {
                                this.env.printError(this.logger, this.module.getName(), javaClassName, "Compiler error:\r\n", ((Object)serr).toString());
                                return null;
                            }
                            this.env.printInfo(this.logger, this.module.getName(), "Compiled:", javaClassName, ((Object)sout).toString(), ((Object)serr).toString());
                            this.deleteBinSource(pathBinSrc);
                            this.saveJavaHash(header, pathSrc, pathBinClass, pathBinHash);
                        }
                        if (this.module.javaURLClassLoader == null) {
                            this.module.javaURLClassLoader = URLClassLoader.newInstance(new URL[]{this.module.javaDirBin.toUri().toURL()}, this.getClass().getClassLoader());
                        }
                        cls = Class.forName(javaClassName, true, this.module.javaURLClassLoader);
                        this.module.javaClasses.put(javaClassName, cls);
                    }
                    catch (Exception e) {
                        this.env.printError(this.logger, e, this.module.getName(), "Java class name: ", javaClassName);
                        return null;
                    }
                    return cls;
                }
            }
        }
    }

    private String constructHeader(String javaClassName) {
        Matcher m = Pattern.compile("(.*)\\.(\\w*$)").matcher(javaClassName);
        boolean hasPackage = m.find();
        String namePackage = hasPackage ? m.group(1) : "";
        String nameClass = hasPackage ? m.group(2) : javaClassName;
        StringBuilder header = new StringBuilder();
        if (!namePackage.isEmpty()) {
            header.append("package ").append(namePackage).append(";\r\n\r\n");
        }
        header.append(IMPORTS).append("\r\npublic class ").append(nameClass).append(" extends ScriptJava {");
        return header.toString();
    }

    private void deleteBinSource(Path pathBinSrc) {
        try {
            Files.delete(pathBinSrc);
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.module.getName(), pathBinSrc.toString());
        }
    }

    private boolean constructBinSource(String header, Path pathSrc, Path pathBinSrc) {
        String footer = "\r\n}\r\n";
        try {
            Files.createDirectories(pathBinSrc.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.module.getName(), "Create directories error:", pathBinSrc.getParent().toString());
            return false;
        }
        boolean res = true;
        int linecnt = 1;
        StringBuilder sb = new StringBuilder();
        Pattern p = Pattern.compile("^\\s*public\\s+class.+extends\\s+ScriptJava.*");
        try (BufferedReader reader = Files.newBufferedReader(pathSrc, StandardCharsets.UTF_8);
             BufferedWriter writer = Files.newBufferedWriter(pathBinSrc, StandardCharsets.UTF_8, new OpenOption[0]);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\r\n");
                if (p.matcher(line).matches()) {
                    header = IMPORTS + sb.toString();
                    footer = "";
                    sb.setLength(0);
                }
                ++linecnt;
            }
            writer.write(header);
            writer.write(sb.toString());
            writer.write(footer);
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.module.getName(), pathSrc.toString(), pathBinSrc.toString());
            res = false;
        }
        return res;
    }

    private boolean checkJavaHash(String header, Path pathSrc, Path pathBinClass, Path pathBinHash) {
        String hashSaved;
        if (!Files.exists(pathBinClass, new LinkOption[0]) || !Files.exists(pathBinHash, new LinkOption[0])) {
            return false;
        }
        String hashCalculated = this.calcHash(header, pathSrc, pathBinClass);
        if (hashCalculated.isEmpty()) {
            return false;
        }
        try (BufferedReader reader = Files.newBufferedReader(pathBinHash, StandardCharsets.UTF_8);){
            hashSaved = reader.readLine();
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.module.getName(), "Hash:", pathBinHash.toString());
            return false;
        }
        return hashCalculated.equals(hashSaved);
    }

    private void saveJavaHash(String header, Path pathSrc, Path pathBinClass, Path pathBinHash) {
        String hash = this.calcHash(header, pathSrc, pathBinClass);
        if (hash.isEmpty()) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(pathBinHash, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(hash);
        }
        catch (IOException e) {
            this.env.printError(this.logger, e, this.module.getName(), "Hash:", pathBinHash.toString());
        }
    }

    private String calcHash(String header, Path pathSrc, Path pathBinClass) {
        StringBuilder sb = new StringBuilder();
        sb.append(ScriptJava.getVersion());
        sb.append('.');
        sb.append(Numbers.toHexString(header.hashCode()));
        sb.append('.');
        if (!CRC.getMD5(pathSrc, sb)) {
            return "";
        }
        sb.append('.');
        if (!CRC.getMD5(pathBinClass, sb)) {
            return "";
        }
        return sb.toString();
    }

    public List<Ref> getRefs() {
        return this.refs;
    }
}

