/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.core.tags.TagPlainBool;
import promauto.jroboplc.core.tags.TagPlainDouble;
import promauto.jroboplc.core.tags.TagPlainInt;
import promauto.jroboplc.core.tags.TagPlainLong;
import promauto.jroboplc.core.tags.TagPlainString;
import promauto.jroboplc.plugin.script.ActionScriptJava;
import promauto.jroboplc.plugin.script.ScriptJavaApi;

public class ScriptJava
implements ScriptJavaApi {
    final Logger logger = LoggerFactory.getLogger(ScriptJava.class);
    private Environment env = null;
    private Module parentModule = null;
    private ActionScriptJava action = null;
    private Object conf;

    public static final String getVersion() {
        return "20200404";
    }

    public final boolean load(Module parentModule, ActionScriptJava action, Object conf) {
        this.env = EnvironmentInst.get();
        this.parentModule = parentModule;
        this.action = action;
        this.conf = conf;
        return this.load();
    }

    @Override
    public final String getModuleName() {
        return this.parentModule.getName();
    }

    @Override
    public final String getId() {
        return this.action.getId();
    }

    @Override
    public final String getArg(String argname, String defval) {
        return this.env.getConfiguration().get(this.conf, argname, defval);
    }

    @Override
    public final int getArg(String argname, int defval) {
        return this.env.getConfiguration().get(this.conf, argname, defval);
    }

    @Override
    public final double getArg(String argname, double defval) {
        return this.env.getConfiguration().get(this.conf, argname, defval);
    }

    @Override
    public final boolean getArg(String argname, boolean defval) {
        return this.env.getConfiguration().get(this.conf, argname, defval);
    }

    @Override
    public final Tag createVar(String tagname, boolean value) {
        return this.action.addVar(new TagPlainBool(this.makeTagName(tagname), value));
    }

    @Override
    public final Tag createVar(String tagname, int value) {
        return this.action.addVar(new TagPlainInt(this.makeTagName(tagname), value));
    }

    @Override
    public final Tag createVar(String tagname, long value) {
        return this.action.addVar(new TagPlainLong(this.makeTagName(tagname), value));
    }

    @Override
    public final Tag createVar(String tagname, double value) {
        return this.action.addVar(new TagPlainDouble(this.makeTagName(tagname), value));
    }

    @Override
    public final Tag createVar(String tagname, String value) {
        return this.action.addVar(new TagPlainString(this.makeTagName(tagname), value));
    }

    @Override
    public final Ref createTag(String tagname, boolean value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createBool(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createTag(String tagname, int value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createInt(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createTag(String tagname, long value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createLong(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createTag(String tagname, double value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createDouble(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createTag(String tagname, String value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createString(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createTag(String tagname, boolean value) {
        return this.createTag(tagname, value, 0);
    }

    @Override
    public final Ref createTag(String tagname, int value) {
        return this.createTag(tagname, value, 0);
    }

    @Override
    public final Ref createTag(String tagname, long value) {
        return this.createTag(tagname, value, 0);
    }

    @Override
    public final Ref createTag(String tagname, double value) {
        return this.createTag(tagname, value, 0);
    }

    @Override
    public final Ref createTag(String tagname, String value) {
        return this.createTag(tagname, value, 0);
    }

    @Override
    public final Ref createRWTag(String tagname, boolean value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createRWBool(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createRWTag(String tagname, int value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createRWInt(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createRWTag(String tagname, long value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createRWLong(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createRWTag(String tagname, double value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createRWDouble(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createRWTag(String tagname, String value, int flags) {
        return this.makeRef(this.parentModule.getTagTable().createRWString(this.makeTagName(tagname), value, flags));
    }

    @Override
    public final Ref createRWTag(String tagname, boolean value) {
        return this.createRWTag(tagname, value, 0);
    }

    @Override
    public final Ref createRWTag(String tagname, int value) {
        return this.createRWTag(tagname, value, 0);
    }

    @Override
    public final Ref createRWTag(String tagname, long value) {
        return this.createRWTag(tagname, value, 0);
    }

    @Override
    public final Ref createRWTag(String tagname, double value) {
        return this.createRWTag(tagname, value, 0);
    }

    @Override
    public final Ref createRWTag(String tagname, String value) {
        return this.createRWTag(tagname, value, 0);
    }

    private String makeTagName(String tagname) {
        if (this.getId().isEmpty()) {
            return tagname;
        }
        return this.getId() + "." + tagname;
    }

    private Ref makeRef(Tag tag) {
        Ref ref = this.env.getRefFactory().createRef();
        ref.init(this.parentModule.getName(), tag.getName());
        this.action.addRef(ref);
        return ref;
    }

    @Override
    public final Ref createRef(String moduleTagname) {
        int k = moduleTagname.indexOf(58);
        if (k < 0) {
            return this.createRef(this.parentModule.getName(), moduleTagname);
        }
        return this.createRef(moduleTagname.substring(0, k), moduleTagname.substring(k + 1));
    }

    @Override
    public final Ref createRef(String module, String tagname) {
        Ref ref = this.env.getRefFactory().createRef();
        ref.init(module, tagname);
        this.action.addRef(ref);
        return ref;
    }

    @Override
    public final void printInfo(String text) {
        this.env.printInfo(this.logger, this.getModuleName(), this.getId(), text);
    }

    @Override
    public final void printError(String text) {
        this.env.printError(this.logger, this.getModuleName(), this.getId(), text);
    }

    @Override
    public final void printError(Throwable e, String text) {
        this.env.printError(this.logger, e, this.getModuleName(), "Id:", this.getId(), "Text:", text);
    }

    @Override
    public final boolean isValid() {
        return this.action.isValid();
    }

    @Override
    public Database getDatabase(String module) {
        Module m = this.env.getModuleManager().getModule(module);
        return m instanceof Database ? (Database)m : null;
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void execute() {
    }
}

