/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script.samples;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.ScriptJava;

public class RadugaMixerScript
extends ScriptJava {
    public static final String UVRD = "UVRD";
    protected static final int STATE_IDLE = 0;
    protected static final int STATE_START_OPEN = 1;
    protected static final int STATE_START_OPEN_DELAY = 2;
    protected static final int STATE_START_MIXER = 3;
    protected static final int STATE_START_CLOSE = 4;
    protected static final int STATE_LOAD = 5;
    protected static final int STATE_EXPOSITION = 6;
    protected static final int STATE_UNLOAD_READY = 7;
    protected static final int STATE_UNLOAD_READY_1 = 8;
    protected static final int STATE_UNLOAD_OPEN = 9;
    protected static final int STATE_UNLOAD_DELAY = 10;
    protected static final int STATE_UNLOAD_DVU = 11;
    protected static final int STATE_CLEAN_START_MIXER = 12;
    protected static final int STATE_CLEAN_DELAY = 13;
    protected static final int STATE_FINISH = 14;
    protected static final String[] STATES = new String[15];
    Ref refZdvClosedA;
    Ref refZdvOpenedA;
    Ref refZdvClosedB;
    Ref refZdvOpenedB;
    Ref refZdvClosedC;
    Ref refZdvOpenedC;
    Ref refMixerMasterOut;
    Ref refDvuOutput;
    Ref refCurWeight;
    Ref refBunkLoad;
    Ref inpStart;
    Ref inpLoaded;
    Ref inpCanUnload;
    Ref tagMixer;
    Ref tagState;
    Ref tagBusy;
    Ref tagLoading;
    Ref tagUnloading;
    Ref tagStateMsg;
    Ref tagTimer;
    Ref tagOverrun;
    Tag varTimerOverrun;
    Ref tagClosed;
    Ref tagOpened;
    Ref tagZdvEnA;
    Ref tagZdvOpA;
    Ref tagZdvEnB;
    Ref tagZdvOpB;
    Ref tagZdvEnC;
    Ref tagZdvOpC;
    Ref tagReset;
    Ref tagDoClose;
    Ref tagDoOpen;
    Ref tagTimeExp;
    Ref tagTimeOverrun;
    Ref tagTimeUnload;
    Ref tagTimeClean;
    Ref tagWeightMin;
    private int stateOpen;
    private int stateClose;

    @Override
    public boolean load() {
        String mix = this.getArg("mix", "");
        String wbunk = this.getArg("wbunk", "");
        String dvu = this.getArg("dvu", "");
        String zdva = "ZDVA_" + mix;
        this.refZdvClosedA = this.createRef(UVRD, zdva + "A_Closed");
        this.refZdvOpenedA = this.createRef(UVRD, zdva + "A_Opened");
        this.refZdvClosedB = this.createRef(UVRD, zdva + "B_Closed");
        this.refZdvOpenedB = this.createRef(UVRD, zdva + "B_Opened");
        this.refZdvClosedC = this.createRef(UVRD, zdva + "C_Closed");
        this.refZdvOpenedC = this.createRef(UVRD, zdva + "C_Opened");
        this.refMixerMasterOut = this.createRef(UVRD, "MCHB_" + mix + "_MasterOut");
        this.refDvuOutput = this.createRef(UVRD, "MDTA_" + dvu + "_DVU_Output");
        this.refCurWeight = wbunk.isEmpty() ? null : this.createRef(wbunk, "CurWeight");
        this.refBunkLoad = wbunk.isEmpty() ? null : this.createRef(wbunk, "Load");
        this.inpStart = this.createTag("Start", 0);
        this.inpLoaded = this.createTag("Loaded", 0);
        this.inpCanUnload = this.createTag("CanUnload", 0);
        this.tagMixer = this.createTag("Mixer", 0);
        this.tagState = this.createTag("State", 0);
        this.tagBusy = this.createTag("Busy", 0);
        this.tagLoading = this.createTag("Loading", 0);
        this.tagUnloading = this.createTag("Unloading", 0);
        this.tagStateMsg = this.createTag("StateMsg", "");
        this.tagTimer = this.createTag("Timer", 0);
        this.tagOverrun = this.createTag("Overrun", 0);
        this.tagClosed = this.createTag("Closed", 0);
        this.tagOpened = this.createTag("Opened", 0);
        this.tagZdvEnA = this.createTag("ZdvEnA", 0);
        this.tagZdvOpA = this.createTag("ZdvOpA", 0);
        this.tagZdvEnB = this.createTag("ZdvEnB", 0);
        this.tagZdvOpB = this.createTag("ZdvOpB", 0);
        this.tagZdvEnC = this.createTag("ZdvEnC", 0);
        this.tagZdvOpC = this.createTag("ZdvOpC", 0);
        this.tagReset = this.createTag("Reset", 0);
        this.tagDoClose = this.createTag("DoClose", 0);
        this.tagDoOpen = this.createTag("DoOpen", 0);
        this.tagTimeExp = this.createTag("TimeExp", 0, 1);
        this.tagTimeOverrun = this.createTag("TimeOverrun", 0, 1);
        this.tagTimeUnload = this.createTag("TimeUnload", 0, 1);
        this.tagTimeClean = this.createTag("TimeClean", 0, 1);
        this.tagWeightMin = this.createTag("WeightMin", 0, 1);
        this.varTimerOverrun = this.createVar("TimerOverrun", 0);
        return true;
    }

    @Override
    public void execute() {
        boolean cmdClose = false;
        boolean cmdOpen = false;
        int state = this.tagState.getInt();
        if (this.tagReset.getBool()) {
            state = 0;
            this.tagTimer.setInt(0);
        }
        if (state == 14) {
            state = 0;
        } else if (state == 0 && this.inpStart.getBool()) {
            if (this.tagReset.getBool()) {
                this.tagReset.setInt(0);
            } else {
                state = 3;
            }
        }
        if (state == 1 && this.tagOpened.getBool()) {
            this.tagTimer.setInt(this.tagTimeUnload.getInt());
            state = 2;
        }
        if (state == 2 && this.timer(this.tagTimer)) {
            state = 3;
        }
        if (state == 3 && this.refMixerMasterOut.getBool()) {
            state = 4;
        }
        if (state == 4 && this.tagClosed.getBool()) {
            state = 5;
        }
        if (state == 5 && this.inpLoaded.getBool()) {
            this.tagTimer.setInt(this.tagTimeExp.getInt());
            state = 6;
        }
        if (state == 6 && this.timer(this.tagTimer)) {
            state = 7;
            this.varTimerOverrun.setInt(this.tagTimeOverrun.getInt());
        }
        if (state == 7 && (this.refCurWeight == null || this.refCurWeight.getLong() <= (long)this.tagWeightMin.getInt()) && this.inpCanUnload.getBool()) {
            state = 8;
        }
        if (state == 8 && (this.refBunkLoad == null || this.refBunkLoad.getInt() > 0)) {
            state = 9;
        }
        if (state == 9 && this.tagOpened.getBool()) {
            state = 10;
            this.tagTimer.setInt(this.tagTimeUnload.getInt());
        }
        if (state == 10 && this.timer(this.tagTimer)) {
            state = 11;
        }
        if (state == 11 && this.refDvuOutput.getInt() == 0) {
            if (this.refMixerMasterOut.getBool()) {
                state = 14;
            } else {
                state = 12;
                this.varTimerOverrun.setInt(0);
            }
        }
        if (state == 12 && this.refMixerMasterOut.getBool()) {
            state = 13;
            this.tagTimer.setInt(this.tagTimeClean.getInt());
        }
        if (state == 13 && this.timer(this.tagTimer)) {
            state = 14;
        }
        this.tagBusy.setBool(state >= 6 && state <= 14);
        this.tagLoading.setBool(state == 5);
        this.tagUnloading.setBool(state >= 8 && state <= 14);
        this.tagMixer.setBool(state >= 3 && state <= 13);
        this.tagOverrun.setBool(state >= 7 && state <= 11 && this.timerOverrun());
        cmdClose = state >= 4 && state <= 8;
        boolean bl = cmdOpen = state != 0 && !cmdClose;
        if (this.tagDoClose.getBool()) {
            cmdClose = true;
            cmdOpen = false;
        } else if (this.tagDoOpen.getBool()) {
            cmdClose = false;
            cmdOpen = true;
        }
        if (cmdClose) {
            this.stateOpen = 0;
            if (this.stateClose == 0) {
                ++this.stateClose;
            }
            if (this.stateClose == 1 && this.refZdvClosedA.getBool()) {
                ++this.stateClose;
            }
            if (this.stateClose == 2 && this.refZdvClosedB.getBool()) {
                ++this.stateClose;
            }
            if (this.stateClose == 3 && this.refZdvClosedC.getBool()) {
                ++this.stateClose;
            }
        } else if (cmdOpen) {
            this.stateClose = 0;
            if (this.stateOpen == 0) {
                ++this.stateOpen;
            }
            if (this.stateOpen == 1 && this.refZdvOpenedC.getBool()) {
                ++this.stateOpen;
            }
            if (this.stateOpen == 2 && this.refZdvOpenedB.getBool()) {
                ++this.stateOpen;
            }
            if (this.stateOpen == 3 && this.refZdvOpenedA.getBool()) {
                ++this.stateOpen;
            }
        } else {
            this.stateClose = 0;
            this.stateOpen = 0;
        }
        this.tagZdvEnA.setBool(this.stateClose >= 1 || this.stateOpen >= 3);
        this.tagZdvOpA.setBool(this.stateOpen >= 3);
        this.tagZdvEnB.setBool(this.stateClose >= 2 || this.stateOpen >= 2);
        this.tagZdvOpB.setBool(this.stateOpen >= 2);
        this.tagZdvEnC.setBool(this.stateClose >= 3 || this.stateOpen >= 1);
        this.tagZdvOpC.setBool(this.stateOpen >= 1);
        this.tagClosed.setBool(this.refZdvClosedA.getBool() && this.refZdvClosedB.getBool() && this.refZdvClosedC.getBool());
        this.tagOpened.setBool(this.refZdvOpenedA.getBool() && this.refZdvOpenedB.getBool() && this.refZdvOpenedC.getBool());
        this.tagState.setInt(state);
        this.tagStateMsg.setString(STATES[state]);
    }

    private boolean timerOverrun() {
        if (this.varTimerOverrun.getInt() > 0) {
            this.varTimerOverrun.setInt(this.varTimerOverrun.getInt() - 1);
            return false;
        }
        return true;
    }

    private boolean timer(Ref timer) {
        if (timer.getInt() > 0) {
            timer.setInt(timer.getInt() - 1);
            return false;
        }
        return true;
    }

    static {
        RadugaMixerScript.STATES[0] = "\u0413\u043e\u0442\u043e\u0432 \u043a \u0441\u0442\u0430\u0440\u0442\u0443 \u0446\u0438\u043a\u043b\u0430";
        RadugaMixerScript.STATES[1] = "\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0437\u0430\u0434\u0432\u0438\u0436\u043a\u0438 \u043f\u0435\u0440\u0435\u0434 \u0441\u0442\u0430\u0440\u0442\u043e\u043c \u0441\u043c\u0435\u0441\u0438\u0442\u0435\u043b\u044f";
        RadugaMixerScript.STATES[2] = "\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u043f\u0435\u0440\u0435\u0434 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\u043c \u0441\u043c\u0435\u0441\u0438\u0442\u0435\u043b\u044f";
        RadugaMixerScript.STATES[3] = "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0441\u043c\u0435\u0441\u0438\u0442\u0435\u043b\u044f";
        RadugaMixerScript.STATES[4] = "\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0437\u0430\u0434\u0432\u0438\u0436\u043a\u0438 \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u043e\u0439";
        RadugaMixerScript.STATES[5] = "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438";
        RadugaMixerScript.STATES[6] = "\u0421\u043c\u0435\u0448\u0438\u0432\u0430\u043d\u0438\u0435";
        RadugaMixerScript.STATES[7] = "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u0438 \u043a \u0440\u0430\u0437\u0433\u0440\u0443\u0437\u043a\u0435";
        RadugaMixerScript.STATES[8] = "\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0440\u0430\u0441\u0445\u043e\u0434\u043e\u043c\u0435\u0440\u0430 \u0432 \u0440\u0435\u0436\u0438\u043c \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438";
        RadugaMixerScript.STATES[9] = "\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0437\u0430\u0434\u0432\u0438\u0436\u043a\u0438";
        RadugaMixerScript.STATES[10] = "\u0420\u0430\u0437\u0433\u0440\u0443\u0437\u043a\u0430";
        RadugaMixerScript.STATES[11] = "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0414\u0412\u0423";
        RadugaMixerScript.STATES[12] = "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043c\u0438\u043a\u0441\u0435\u0440\u0430 \u0434\u043b\u044f \u043e\u0447\u0438\u0441\u0442\u043a\u0438";
        RadugaMixerScript.STATES[13] = "\u041e\u0447\u0438\u0441\u0442\u043a\u0430";
        RadugaMixerScript.STATES[14] = "\u0426\u0438\u043a\u043b \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d";
    }
}

