/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script.utils;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.format.DateTimeFormatter;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.ScriptJava;

public class CsvToSqlImportScript
extends ScriptJava {
    private static final int MAX_FILES_IN_DIR = 80;
    private final Logger logger = LoggerFactory.getLogger(CsvToSqlImportScript.class);
    private static final DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("_yyyyMMdd_HHmmss");
    Ref tagCnt;
    Ref tagEnable;
    Database db;
    String dbname;
    String sql;
    String dir;
    String filemask;

    @Override
    public boolean load() {
        this.tagCnt = this.createTag("cnt", 0);
        this.tagEnable = this.createTag("enable", 0, 1);
        this.dbname = this.getArg("db", "db");
        this.db = null;
        this.sql = this.getArg("sql", "");
        this.dir = this.getArg("dir", "");
        this.filemask = this.getArg("filemask", "");
        return true;
    }

    @Override
    public boolean prepare() {
        this.db = this.getDatabase(this.dbname);
        if (this.db == null) {
            this.printError("Database module is not found: " + this.dbname);
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        if (!this.db.isConnected() || !this.tagEnable.getBool()) {
            return;
        }
        TreeSet filenames = new TreeSet();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(Paths.get(this.dir, new String[0]), this.filemask);){
            ds.forEach(path -> filenames.add(path.toString()));
            for (String filename : filenames) {
                this.tagCnt.setInt(this.tagCnt.getInt() + 1);
                this.printInfo("Process file: " + filename);
                if (this.processFile(Paths.get(filename, new String[0]))) continue;
                this.printError("Import from file failed: " + filename);
                return;
            }
        }
        catch (IOException e) {
            this.printError(e, "Iterate over directory failed: " + this.dir.toString() + ", mask: " + this.filemask);
            return;
        }
    }

    private boolean processFile(Path path) {
        String sqlPrepared = "";
        try (Statement st = this.db.getConnection().createStatement();
             Stream<String> lines = Files.lines(path);){
            for (String line : lines.collect(Collectors.toList())) {
                this.printInfo(line);
                String[] values = line.split(";");
                for (int i = 0; i < values.length; ++i) {
                    if (!values[i].isEmpty()) continue;
                    values[i] = "0";
                }
                sqlPrepared = String.format(this.sql, values);
                st.executeUpdate(sqlPrepared);
            }
            this.db.commit();
            Files.delete(path);
        }
        catch (IOException | SQLException e) {
            this.printError(e, "Process file failed: " + path.toString() + ", sql: " + sqlPrepared);
            try {
                Files.move(path, Paths.get(path.toString() + ".failed", new String[0]), new CopyOption[0]);
            }
            catch (IOException ex) {
                this.printError(e, "Rename failed: " + path.toString());
            }
            return false;
        }
        return true;
    }
}

