/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.tcpconsole;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.TcpServerChannel;
import promauto.jroboplc.core.api.TcpServerPort;
import promauto.jroboplc.core.api.TcpSubscriber;
import promauto.jroboplc.plugin.tcpconsole.TcpConsoleClient;

public class TcpConsoleModule
extends AbstractModule
implements TcpSubscriber {
    public static final String ENTER_PASSWORD = "Enter password: ";
    private final Logger logger = LoggerFactory.getLogger(TcpConsoleModule.class);
    protected int portnum;
    protected String welcome;
    protected String password;
    protected boolean needPassword;
    protected List<String> listForbidden = null;
    protected Pattern regexForbidden = null;
    private Set<TcpConsoleClient> clients = new HashSet<TcpConsoleClient>();

    public TcpConsoleModule(Plugin plugin, String name) {
        super(plugin, name);
        this.taskable = false;
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.portnum = cm.get(conf, "portnum", 0);
        this.welcome = cm.get(conf, "welcome", "Welcome to JRoboPLC!\r\n(use 'h' for help)") + "\r\n";
        this.password = cm.get(conf, "password", "");
        this.listForbidden = null;
        this.regexForbidden = null;
        Object forbidden = cm.get(conf, "forbidden");
        if (forbidden != null) {
            if (forbidden instanceof List) {
                this.listForbidden = new LinkedList<String>();
                cm.toList(cm.get(conf, "forbidden")).stream().forEach(s -> this.listForbidden.add(s.toString()));
            } else if (!forbidden.toString().isEmpty()) {
                try {
                    this.regexForbidden = Pattern.compile(forbidden.toString());
                }
                catch (PatternSyntaxException e) {
                    this.env.printError(this.logger, e, this.name);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean prepareModule() {
        if (this.env.getTcpServer().subscribe(this.portnum, this)) {
            return true;
        }
        this.env.printError(this.logger, this.name);
        return false;
    }

    @Override
    public String getInfo() {
        return this.enable ? "p" + this.portnum : "disabled";
    }

    @Override
    public boolean onTcpServerClientConnected(TcpServerChannel channel) {
        this.env.printInfo(this.logger, this.name, "Connected:", channel.getRemoteAddress().getAddress().getHostAddress());
        TcpConsoleClient client = new TcpConsoleClient(this.env, this, channel);
        client.setProperty("ansi", "on");
        this.env.getConsoleManager().addConsole(client);
        channel.setAttachedObject(client);
        this.clients.add(client);
        this.needPassword = !this.password.isEmpty();
        channel.write(this.welcome + (this.needPassword ? ENTER_PASSWORD : client.getPrompt()));
        return true;
    }

    @Override
    public boolean onTcpServerClientDisconnected(TcpServerChannel channel) {
        this.env.printInfo(this.logger, this.name, "Disconnected:", channel.getRemoteAddress().getAddress().getHostAddress());
        Object obj = channel.getAttachedObject();
        if (obj != null && obj instanceof TcpConsoleClient) {
            TcpConsoleClient client = (TcpConsoleClient)obj;
            client.onDisconnect();
            this.env.getConsoleManager().removeConsole(client);
            return this.clients.remove(client);
        }
        return false;
    }

    @Override
    public boolean onTcpServerRequest(TcpServerChannel channel, String request) {
        if (channel.getAttachedObject() != null && channel.getAttachedObject() instanceof TcpConsoleClient) {
            ((TcpConsoleClient)channel.getAttachedObject()).onRequest(channel, request);
        }
        return true;
    }

    @Override
    protected boolean reload() {
        TcpConsoleModule tmp = new TcpConsoleModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        TcpServerPort port_old = this.env.getTcpServer().getPortBySubscriber(this);
        TcpServerPort port_new = this.env.getTcpServer().getPortByNum(tmp.portnum);
        if (tmp.enable && port_new == null) {
            this.env.printError(this.logger, this.name, "Port not found: " + tmp.portnum);
            return false;
        }
        this.copySettingsFrom(tmp);
        int portnum_old = this.portnum;
        this.portnum = tmp.portnum;
        this.welcome = tmp.welcome;
        this.password = tmp.password;
        this.listForbidden = tmp.listForbidden;
        this.regexForbidden = tmp.regexForbidden;
        if (this.enable && this.env.isRunning() && port_new != null && port_old != port_new) {
            port_new.setSubscriber(this);
        }
        if (port_old != null && port_old != port_new) {
            this.env.getTcpServer().disconnect(portnum_old);
            port_old.setSubscriber(null);
        }
        return true;
    }
}

