/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.tcpserver;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.TcpServerChannel;
import promauto.jroboplc.core.api.TcpServerPort;
import promauto.jroboplc.core.api.TcpSubscriber;
import promauto.jroboplc.plugin.tcpserver.TcpServerChannelImpl;
import promauto.utils.Strings;

public class TcpServerPortImpl
implements TcpServerPort {
    private int portnum;
    private int porttcp;
    private boolean enable;
    private int maxcon;
    private boolean logging;
    private String format;
    private volatile TcpSubscriber subscriber = null;
    private Map<Channel, TcpServerChannelImpl> channels = new ConcurrentHashMap<Channel, TcpServerChannelImpl>();
    private Pattern incl = null;
    private Pattern excl = null;
    private long aliveTimeout;

    public void load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.portnum = cm.get(conf, "portnum", 0);
        this.porttcp = cm.get(conf, "porttcp", 0);
        this.enable = cm.get(conf, "enable", true);
        this.maxcon = cm.get(conf, "maxcon", 32);
        this.aliveTimeout = cm.get(conf, "aliveTimeout_s", 60) * 1000;
        this.logging = cm.get(conf, "logging", false);
        this.format = cm.get(conf, "format", "text");
        this.incl = Strings.getFilterPattern(cm.get(conf, "incl", ""));
        this.excl = Strings.getFilterPattern(cm.get(conf, "excl", ""));
    }

    @Override
    public int getPortnum() {
        return this.portnum;
    }

    @Override
    public int getPorttcp() {
        return this.porttcp;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public boolean isEnabled() {
        return this.enable;
    }

    @Override
    public synchronized Collection<? extends TcpServerChannel> getChannels() {
        return this.channels.values();
    }

    @Override
    public TcpSubscriber getSubscriber() {
        return this.subscriber;
    }

    @Override
    public void setSubscriber(TcpSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public synchronized TcpServerChannel addChannel(Channel channel) {
        InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
        String hostip = address.getAddress().getHostAddress();
        if (this.maxcon > 0 && this.channels.size() >= this.maxcon) {
            return null;
        }
        if (this.incl != null && !this.incl.matcher(hostip).matches()) {
            return null;
        }
        if (this.excl != null && this.excl.matcher(hostip).matches()) {
            return null;
        }
        TcpServerChannelImpl ch = new TcpServerChannelImpl(channel, this);
        ch.setLogEnable(this.logging);
        this.channels.put(channel, ch);
        return ch;
    }

    public synchronized void removeChannel(Channel channel) {
        this.channels.remove(channel);
    }

    public boolean close(long timeout) {
        return this.channels.values().stream().allMatch(ch -> ch.close(timeout));
    }

    public boolean isDisconnected() {
        return this.channels.isEmpty();
    }

    @Override
    public long getAliveTimeout() {
        return this.aliveTimeout;
    }
}

