/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.wessvr.ArchiveConfig;
import promauto.jroboplc.plugin.wessvr.DeviceBase;

public class ArchiveBase {
    private final Logger logger = LoggerFactory.getLogger(ArchiveBase.class);
    public static final int CHECK_DELAY_SECS = 60;
    public static final int DELTAWES_BOOST_COEFF = 5;
    private final DeviceBase device;
    private final String tblMain;
    private final String tblStat;
    private final int interval;
    private LocalDateTime dtbeg;
    private LocalDateTime dtend;
    private int pertype;
    private long period;
    private long wes;
    private long swbeg;
    private long swend;
    private long wnum;
    private long wnbeg;
    private long wnend;
    private double outwes;
    private double outnum;
    private int idprod;
    private int idbrig;
    private int idbatch;
    private boolean initialized;
    private final String sqlForeignIds;
    private int timeStepBack;
    private int timeBigDeltaWes;
    private long lastDeltaWes;
    private final DateTimeFormatter formatter;
    private final Tag tagPertype;
    private final Tag tagPeriod;
    private final Tag tagWes;
    private final Tag tagWnum;
    private long currentStatWes;
    private long currentStatWnum;

    public ArchiveBase(DeviceBase device, ArchiveConfig.Item archiveConfigItem) {
        this.device = device;
        this.formatter = device.module.getDatabase().getTimestampFormatter();
        this.tblMain = device.module.makeTableName(archiveConfigItem.tblMain);
        this.tblStat = device.module.makeTableName(archiveConfigItem.tblStat);
        this.interval = archiveConfigItem.interval;
        String tblModules = device.module.makeTableName("modules");
        this.sqlForeignIds = String.format("select idprod, idbrig, idbatch from %s where idm=%d", tblModules, device.idm);
        this.tagPertype = device.getOrCreateTag(Tag.Type.INT, archiveConfigItem.tblMain + ".pertype");
        this.tagPeriod = device.getOrCreateTag(Tag.Type.LONG, archiveConfigItem.tblMain + ".period");
        this.tagWes = device.getOrCreateTag(Tag.Type.INT, archiveConfigItem.tblMain + ".wes");
        this.tagWnum = device.getOrCreateTag(Tag.Type.INT, archiveConfigItem.tblMain + ".wnum");
        this.initialized = false;
    }

    public void init() throws SQLException {
        this.dtend = LocalDateTime.now();
        boolean res = false;
        String sql = String.format("select dtbeg, period, pertype, wes, swbeg, swend, wnum, wnbeg, wnend, idprod, idbrig, idbatch from %s where idm=%d", this.tblMain, this.device.idm);
        try (ResultSet rs = this.device.module.executeQuery(sql);){
            if (rs.next()) {
                this.dtbeg = rs.getTimestamp("dtbeg").toLocalDateTime();
                this.pertype = this.calcPertype(this.dtbeg);
                this.period = this.calcPeriod(this.dtbeg);
                this.wes = rs.getLong("wes");
                this.swbeg = rs.getLong("swbeg");
                this.swend = rs.getLong("swend");
                this.wnum = rs.getLong("wnum");
                this.wnbeg = rs.getLong("wnbeg");
                this.wnend = rs.getLong("wnend");
                this.idprod = rs.getInt("idprod");
                this.idbrig = rs.getInt("idbrig");
                this.idbatch = rs.getInt("idbatch");
                res = true;
            }
        }
        if (!res) {
            this.dtbeg = this.device.refs.getDtRead();
            this.pertype = this.calcPertype(this.dtbeg);
            this.period = this.calcPeriod(this.dtbeg);
            this.wes = 0L;
            this.swend = this.swbeg = this.device.getSumWeight();
            this.wnum = 0L;
            this.wnend = this.wnbeg = this.device.getSumNum();
            rs = this.device.module.executeQuery(this.sqlForeignIds);
            var4_4 = null;
            try {
                if (rs.next()) {
                    this.idprod = rs.getInt(1);
                    this.idbrig = rs.getInt(2);
                    this.idbatch = rs.getInt(3);
                } else {
                    this.idprod = 0;
                    this.idbrig = 0;
                    this.idbatch = 0;
                }
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_4 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            this.writeMain();
        }
        this.fetchCurrentStats();
        this.timeStepBack = 0;
        this.timeBigDeltaWes = 0;
        this.lastDeltaWes = 0L;
        this.initialized = true;
    }

    private void fetchCurrentStats() throws SQLException {
        String sql = String.format("select sum(wes), sum(wnum) from %s where idm=%d and period=%d", this.tblStat, this.device.idm, this.period);
        try (ResultSet rs = this.device.module.executeQuery(sql);){
            if (rs.next()) {
                this.currentStatWes = rs.getLong(1);
                this.currentStatWnum = rs.getLong(2);
            } else {
                this.resetCurrentStats();
            }
        }
    }

    private void resetCurrentStats() {
        this.currentStatWes = 0L;
        this.currentStatWnum = 0L;
    }

    private void addCurrentStats() {
        this.currentStatWes += this.wes;
        this.currentStatWnum += this.wnum;
    }

    public void execute() throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        this.dtend = this.device.refs.getDtRead();
        long swend_new = this.device.getSumWeight();
        long wnend_new = this.device.getSumNum();
        int pertype_new = this.calcPertype(this.dtend);
        long period_new = this.calcPeriod(this.dtend);
        int idprod_new = 0;
        int idbrig_new = 0;
        int idbatch_new = 0;
        try (ResultSet rs = this.device.module.executeQuery(this.sqlForeignIds);){
            if (rs.next()) {
                idprod_new = rs.getInt(1);
                idbrig_new = rs.getInt(2);
                idbatch_new = rs.getInt(3);
            }
        }
        if (this.device.isReplaced() && (this.swend != swend_new || this.wnend != wnend_new)) {
            this.writeStat(2);
            this.dtbeg = this.dtend;
            this.swend = swend_new;
            this.wnend = wnend_new;
            this.swbeg = this.swend;
            this.wnbeg = this.wnend;
            this.idprod = idprod_new;
            this.idbrig = idbrig_new;
            this.idbatch = idbatch_new;
            this.pertype = pertype_new;
            this.period = period_new;
            this.wnum = 0L;
            this.wes = 0L;
            this.writeMain();
        }
        if (this.checkStepBack(swend_new, wnend_new) && this.checkBigDeltaWes(swend_new)) {
            if (this.swend > swend_new || this.wnend > wnend_new) {
                this.writeStat(0);
                this.dtbeg = this.dtend;
                this.swbeg = this.swend;
                this.swend = swend_new;
                this.wes = this.swbeg <= this.swend ? this.swend - this.swbeg : this.device.sizeSumWeight - this.swbeg + this.swend;
                this.wnbeg = this.wnend;
                this.wnend = wnend_new;
                long l = this.wnum = this.wnbeg <= this.wnend ? this.wnend - this.wnbeg : this.device.sizeSumNum - this.wnbeg + this.wnend;
                if (this.period == period_new) {
                    this.addCurrentStats();
                }
                this.idprod = idprod_new;
                this.idbrig = idbrig_new;
                this.idbatch = idbatch_new;
                this.pertype = pertype_new;
                this.period = period_new;
                if (this.device.sizeSumWeight == 0L && this.device.sizeSumNum == 0L) {
                    this.swbeg = 0L;
                    this.wnbeg = 0L;
                } else {
                    this.writeStat(1);
                    this.swbeg = this.swend;
                    this.wnbeg = this.wnend;
                }
                this.wnum = 0L;
                this.wes = 0L;
                this.writeMain();
            }
            if (this.period != period_new && this.interval >= 0 || this.idprod != idprod_new || this.idbrig != idbrig_new || this.idbatch != idbatch_new) {
                boolean ignoreStat;
                this.swend = swend_new;
                this.wes = this.swend - this.swbeg;
                this.wnend = wnend_new;
                this.wnum = this.wnend - this.wnbeg;
                boolean samePeriod = this.period == period_new;
                boolean bl = ignoreStat = this.device.module.isIgnoreZeroStat() && samePeriod && this.wes == 0L && this.wnum == 0L;
                if (!ignoreStat) {
                    this.writeStat(0);
                }
                if (samePeriod) {
                    this.addCurrentStats();
                } else {
                    this.resetCurrentStats();
                }
                this.dtbeg = this.dtend;
                this.idprod = idprod_new;
                this.idbrig = idbrig_new;
                this.idbatch = idbatch_new;
                this.pertype = pertype_new;
                this.period = period_new;
                this.swbeg = this.swend;
                this.wnbeg = this.wnend;
                this.wnum = 0L;
                this.wes = 0L;
                this.writeMain();
            }
            if (this.swend < swend_new || this.wnend < wnend_new) {
                this.swend = swend_new;
                this.wes = this.swend - this.swbeg;
                this.wnend = wnend_new;
                this.wnum = this.wnend - this.wnbeg;
                this.writeMain();
            }
        }
        this.tagPertype.setInt(this.pertype);
        this.tagPeriod.setLong(this.period);
        this.tagWes.setInt((int)(this.wes + this.currentStatWes));
        this.tagWnum.setInt((int)(this.wnum + this.currentStatWnum));
    }

    private boolean checkStepBack(long swend_new, long wnend_new) {
        if (this.swend <= swend_new && this.wnend <= wnend_new) {
            this.timeStepBack = 0;
            return true;
        }
        if (this.timeStepBack == 0) {
            this.timeStepBack = this.device.refUpdateTime.getValue().getInt();
            EnvironmentInst.get().logInfo(this.logger, this.device.module.getName() + " " + this.device.name + " " + this.tblMain + " StepBack started, swend: " + this.swend + "->" + swend_new + " wnend: " + this.wnend + "->" + wnend_new + " time=" + this.timeStepBack);
        } else if (this.substructTimes(this.device.refUpdateTime.getValue().getInt(), this.timeStepBack) > 60) {
            EnvironmentInst.get().logInfo(this.logger, this.device.module.getName() + " " + this.device.name + " " + this.tblMain + " StepBack PASSED, swend: " + this.swend + "->" + swend_new + " wnend:" + this.wnend + "->" + wnend_new + " time=" + this.device.refUpdateTime.getValue().getInt());
            this.timeStepBack = 0;
            return true;
        }
        return false;
    }

    private boolean checkBigDeltaWes(long swend_new) {
        if (this.swend >= swend_new) {
            this.timeBigDeltaWes = 0;
            return true;
        }
        long deltaWes = swend_new - this.swend;
        if (this.device.wesIncMax != 0 ? deltaWes < (long)this.device.wesIncMax : this.lastDeltaWes == 0L || deltaWes < this.lastDeltaWes * 5L) {
            this.lastDeltaWes = deltaWes;
            this.timeBigDeltaWes = 0;
            return true;
        }
        if (this.timeBigDeltaWes == 0) {
            this.timeBigDeltaWes = this.device.refUpdateTime.getValue().getInt();
            EnvironmentInst.get().logInfo(this.logger, this.device.module.getName() + " " + this.device.name + " " + this.tblMain + " BigDeltaWes started, swend: " + this.swend + "->" + swend_new + " time=" + this.timeBigDeltaWes + " deltawes=" + deltaWes + " wmax=" + (this.device.wesIncMax != 0 ? (long)this.device.wesIncMax : this.lastDeltaWes * 5L));
        } else if (this.substructTimes(this.device.refUpdateTime.getValue().getInt(), this.timeBigDeltaWes) > 60) {
            this.lastDeltaWes = deltaWes;
            this.timeBigDeltaWes = 0;
            EnvironmentInst.get().logInfo(this.logger, this.device.module.getName() + " " + this.device.name + " " + this.tblMain + " BigDeltaWes PASSED, swend: " + this.swend + "->" + swend_new + " time=" + this.device.refUpdateTime.getValue().getInt() + " deltawes=" + deltaWes);
            return true;
        }
        return false;
    }

    private int substructTimes(int time1, int time2) {
        if ((time1 = this.converTimeToSeconds(time1)) < (time2 = this.converTimeToSeconds(time2))) {
            time1 += 86400;
        }
        return time1 - time2;
    }

    private int converTimeToSeconds(int time) {
        return time / 10000 * 3600 + time % 10000 / 100 * 60 + time % 100;
    }

    private void writeMain() throws SQLException {
        this.calcOutputs();
        String sql = String.format(Locale.ROOT, "update or insert into %s (idm, pertype, period, dtbeg, wes, swbeg, swend, wnum, wnbeg, wnend, outwes, outnum, idprod, idbrig, idbatch) values (%d, %d, %d, '%s', %d, %d, %d, %d, %d, %d, %f, %f, %d, %d, %d) matching (idm)", this.tblMain, this.device.idm, this.pertype, this.period, this.dtbeg.format(this.formatter), this.wes, this.swbeg, this.swend, this.wnum, this.wnbeg, this.wnend, this.outwes, this.outnum, this.idprod, this.idbrig, this.idbatch);
        this.device.module.executeUpdate(sql);
    }

    private void writeStat(int flagSetback) throws SQLException {
        this.calcOutputs();
        String sql = String.format(Locale.ROOT, "insert into %s (idm, pertype, period, dtbeg, dtend, setback, wes, swbeg, swend, wnum, wnbeg, wnend, outwes, outnum, idprod, idbrig, idbatch) values (%d, %d, %d, '%s', '%s', %d, %d, %d, %d, %d, %d, %d, %f, %f, %d, %d, %d)", this.tblStat, this.device.idm, this.pertype, this.period, this.dtbeg.format(this.formatter), this.dtend.format(this.formatter), flagSetback, this.wes, this.swbeg, this.swend, this.wnum, this.wnbeg, this.wnend, this.outwes, this.outnum, this.idprod, this.idbrig, this.idbatch);
        this.device.module.executeUpdate(sql);
    }

    private void calcOutputs() {
        double hours = (double)ChronoUnit.SECONDS.between(this.dtbeg, this.dtend) / 3600.0;
        if (hours > 0.0) {
            this.outwes = (double)this.wes / hours;
            this.outnum = (double)this.wnum / hours;
        } else {
            this.outwes = 0.0;
            this.outnum = 0.0;
        }
    }

    private int calcPertype(LocalDateTime ldt) {
        int pertype = this.interval <= 0 ? 10 + this.device.shiftset.getShiftNum(ldt) : (this.interval < 60 ? 10000 + ldt.getHour() * 100 + ldt.getMinute() - ldt.getMinute() % this.interval : 100 + ldt.getHour());
        return pertype;
    }

    protected long calcPeriod(LocalDateTime ldt) {
        if (this.interval == 0 && this.device.shiftset.isAfterMidnight(ldt)) {
            ldt = ldt.minusDays(1L);
        }
        long period = ldt.getYear() * 10000 + ldt.getMonth().getValue() * 100 + ldt.getDayOfMonth();
        if (this.interval <= 0) {
            period = period * 10L + (long)this.device.shiftset.getShiftNum(ldt);
        } else if (this.interval == 60) {
            period = period * 100L + (long)ldt.getHour();
        } else if (this.interval < 60) {
            period = period * 10000L + (long)(ldt.getHour() * 100) + (long)ldt.getMinute() - (long)(ldt.getMinute() % this.interval);
        } else if (this.interval < 1440) {
            period = period * 100L + (long)ldt.getHour() - (long)(ldt.getHour() % (this.interval / 60));
        }
        return period;
    }

    public void onConnectError() {
        this.timeStepBack = 0;
        this.timeBigDeltaWes = 0;
    }
}

