/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.wessvr.WessvrModule;
import promauto.utils.ParamsMap;

public class ArchiveConfig {
    private final Logger logger = LoggerFactory.getLogger(ArchiveConfig.class);
    private WessvrModule module;
    public final List<Item> items = new ArrayList<Item>();

    public ArchiveConfig(WessvrModule module) {
        this.module = module;
    }

    public boolean load(Object conf) {
        this.items.clear();
        Environment env = EnvironmentInst.get();
        Configuration cm = env.getConfiguration();
        List<Object> recs = cm.toList(cm.get(conf, "arctables"));
        if (recs.size() == 0) {
            this.items.add(new Item("MAIN", "STAT", 0));
            this.items.add(new Item("MAINHR", "STATHR", 60));
            return true;
        }
        for (Object rec : recs) {
            Item item = new Item(cm.get(rec, "main", "").trim(), cm.get(rec, "stat", "").trim(), cm.get(rec, "interval", 0));
            if (item.tblMain.isEmpty() || item.tblStat.isEmpty()) {
                env.printError(this.logger, this.module.getName(), "Empty table names", item.toString());
            }
            this.items.add(item);
        }
        return true;
    }

    public boolean createTables() {
        for (Item item : this.items) {
            ParamsMap params = new ParamsMap("schema=" + this.module.getSchema(), "tblmain=" + item.tblMain, "tblstat=" + item.tblStat);
            if (this.module.getDatabase().executeScript((String)"wessvr.arctables", (Map<String, String>)params).success) continue;
            EnvironmentInst.get().printError(this.logger, this.module.getName(), "Failed to create table", item.toString());
            return false;
        }
        return true;
    }

    public static class Item {
        public String tblMain;
        public String tblStat;
        public int interval;

        public Item(String tblMain, String tblStat, int interval) {
            this.tblMain = tblMain;
            this.tblStat = tblStat;
            this.interval = interval;
        }

        public String toString() {
            return "main=" + this.tblMain + " stat=" + this.tblStat + " interval=" + this.interval;
        }
    }
}

