/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;
import org.tanukisoftware.wrapper.test.RuntimeExec;

public class ExecWriteAndRead {
    private static boolean m_debug = false;
    private static final int CHILD_SLEEP_TIME_S = 0;
    private static final long CHILD_SLEEP_TIME_MS = 0L;
    private static final String CHILD_INPUT_STRING = "some input..." + System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTest(String command, String testId, boolean newProcessGroup, int startType, long expectedTimeMs) {
        RuntimeExec.beginCase(testId);
        try {
            WrapperProcessConfig wrapperProcessConfig = new WrapperProcessConfig().setNewProcessGroup(newProcessGroup).setStartType(startType);
            try {
                RuntimeExec.handleWrapperProcess(testId, command, wrapperProcessConfig, 0L, true, false, CHILD_INPUT_STRING, false, 2, "(.*)(" + CHILD_INPUT_STRING + ")(.*)", 0, m_debug, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId, expectedTimeMs);
        }
    }

    private static void doTests(String executable, boolean newProcessGroup, int startType) {
        StringBuffer sb = new StringBuffer();
        if (newProcessGroup) {
            sb.append("NewProcessGroup");
        } else {
            sb.append("SharedProcessGroup");
        }
        sb.append(" ");
        String context = sb.toString();
        ExecWriteAndRead.doTest(executable + " -readinput 0 " + 0, context + "simplewaiter : ", newProcessGroup, startType, 0L);
        if (!WrapperManager.isWindows()) {
            ExecWriteAndRead.doTest("bash -c \"" + executable + " -readinput 0 " + 0 + "\"", context + "Bash+simplewaiter : ", newProcessGroup, startType, 0L);
            ExecWriteAndRead.doTest("bash -c \"export FOO=bar;" + executable + " -readinput 0 " + 0 + "\"", context + "Bash+env+simplewaiter : ", newProcessGroup, startType, 0L);
        }
    }

    public static void main(String[] args) {
        RuntimeExec.c_testsPerformed = 0;
        RuntimeExec.c_testsFailed = 0;
        String simplewaiter = WrapperManager.isWindows() ? "..\\test\\simplewaiter.exe" : "../test/simplewaiter";
        if (!WrapperManager.isWindows() && args.length > 0 && "true".equals(args[0])) {
            System.out.println(Main.getRes().getString("DEBUG mode enabled."));
            m_debug = true;
        }
        System.out.println("");
        System.out.println(Main.getRes().getString("A bunch of tests will be run. Please check that the input written matches the output printed."));
        if (WrapperProcessConfig.isSupported((int)2)) {
            ExecWriteAndRead.doTests(simplewaiter, true, 2);
            ExecWriteAndRead.doTests(simplewaiter, false, 2);
        }
        if (WrapperProcessConfig.isSupported((int)3)) {
            ExecWriteAndRead.doTests(simplewaiter, true, 3);
            ExecWriteAndRead.doTests(simplewaiter, false, 3);
        }
        if (WrapperProcessConfig.isSupported((int)1)) {
            ExecWriteAndRead.doTests(simplewaiter, true, 1);
            ExecWriteAndRead.doTests(simplewaiter, false, 1);
        }
        int nbTestsFailed = RuntimeExec.c_testsFailed;
        int nbTestsPassed = RuntimeExec.c_testsPerformed - nbTestsFailed;
        System.out.println("");
        System.out.println(Main.getRes().getString("[PASSED] {0}", (Object)Integer.toString(nbTestsPassed)));
        System.out.println(Main.getRes().getString("[FAILED] {0}", (Object)Integer.toString(nbTestsFailed)));
        if (nbTestsFailed > 0) {
            System.exit(1);
        }
    }
}

