/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.ConfigurationYaml;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.ModuleManager;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.Task;

public class ModuleManagerImpl
implements ModuleManager {
    final Logger logger = LoggerFactory.getLogger(ModuleManagerImpl.class);
    private final Environment env;
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();
    private final Map<String, JrModule> modules = new HashMap<String, JrModule>();
    private List<JrModule> extmodules = null;
    private int lastStatusTextLen = 0;

    public ModuleManagerImpl() {
        this.env = EnvironmentInst.get();
    }

    public void addPlugins(Plugin ... plugins) {
        Arrays.stream(plugins).forEach(plugin -> this.plugins.put(plugin.getPluginName(), (Plugin)plugin));
    }

    private void printStatus(String text) {
        if (this.lastStatusTextLen > 0) {
            this.env.getConsole().print(String.format("%-" + this.lastStatusTextLen + "s\r", " "));
        }
        this.lastStatusTextLen = text.length();
        this.env.getConsole().print(text + "\r");
    }

    @Override
    public List<Plugin> getPlugins() {
        return null;
    }

    @Override
    public Set<JrModule> getModules() {
        TreeSet<JrModule> mdlset = new TreeSet<JrModule>(Comparator.comparing(JrModule::getName));
        mdlset.addAll(this.modules.values());
        return mdlset;
    }

    @Override
    public List<JrModule> getModulesWithExternalTags() {
        if (this.extmodules == null) {
            this.extmodules = this.modules.values().stream().filter(JrModule::canHaveExternalTags).collect(Collectors.toList());
        }
        return this.extmodules;
    }

    @Override
    public Map<String, Tag> getTagsAll() {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        for (JrModule m : this.modules.values()) {
            for (Tag tag : m.getTagTable().values()) {
                if (tag.getStatus() == Tag.Status.Deleted) continue;
                if (tag.hasFlags(4)) {
                    tags.put(tag.getName(), tag);
                    continue;
                }
                tags.put(m.getName() + '.' + tag.getName(), tag);
            }
        }
        return tags;
    }

    @Override
    public JrModule getModule(String name) {
        return this.modules.get(name);
    }

    @Override
    public <T> T getModule(String name, Class<? extends T> cls) {
        JrModule module = this.modules.get(name);
        return cls.isInstance(module) ? (T)cls.cast(module) : null;
    }

    @Override
    public Tag searchTag(String name) {
        for (JrModule module : this.modules.values()) {
            Tag tag = module.getTagTable().get(name);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    @Override
    public Tag searchExternalTag(String name) {
        for (JrModule module : this.getModulesWithExternalTags()) {
            Tag tag = module.getTagTable().get(name);
            if (tag == null || !tag.hasFlags(4)) continue;
            return tag;
        }
        return null;
    }

    @Override
    public boolean loadModules() {
        AtomicBoolean result = new AtomicBoolean(true);
        Configuration cm = this.env.getConfiguration();
        cm.getRoot().forEach((pkey, pconf) -> {
            if (pkey.startsWith("plugin.") && pconf != null && cm.get(pconf, "enable", true)) {
                String pluginName = pkey.substring(7);
                cm.toMap(pconf).forEach((mkey, mconf) -> {
                    if (mkey.startsWith("module.") && mconf != null) {
                        String moduleName = mkey.substring(7);
                        result.compareAndSet(true, this.appendModule(pluginName, moduleName));
                    }
                });
            }
        });
        this.printStatus("");
        return result.get();
    }

    @Override
    public boolean appendModule(String plgname, String modname) {
        Optional<Plugin> plugin = this.getOrLoadPlugin(plgname);
        if (!plugin.isPresent()) {
            this.env.printError(this.logger, "Plugin not found: ", plgname);
            return false;
        }
        JrModule module = this.getModule(modname);
        if (module != null) {
            this.env.printError(this.logger, "Module already exists: ", modname);
            return false;
        }
        Configuration cm = this.env.getConfiguration();
        Object conf = cm.getModuleConf(plgname, modname);
        if (conf == null) {
            return false;
        }
        module = plugin.get().createModule(modname, conf);
        if (module == null) {
            return false;
        }
        if (this.env.isRunning()) {
            if (!module.prepare()) {
                module.closedown();
                return false;
            }
            if (module instanceof Task) {
                module.execute();
            }
        }
        this.modules.put(modname, module);
        this.extmodules = null;
        this.printStatus("  - module: " + modname);
        return true;
    }

    private Optional<Plugin> getOrLoadPlugin(String plgname) {
        Plugin plugin = this.plugins.get(plgname);
        if (plugin != null) {
            return Optional.of(plugin);
        }
        Configuration cm = this.env.getConfiguration();
        String pluginClassName = (String)cm.toMap(cm.get(cm.getRoot(), "plugin")).get(plgname);
        if (pluginClassName == null) {
            return Optional.empty();
        }
        try {
            Class<?> cls = Class.forName(pluginClassName);
            plugin = (Plugin)cls.newInstance();
            plugin.initialize();
            this.plugins.put(plgname, plugin);
            this.printStatus("...plugin " + plugin.getPluginName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.env.printError(this.logger, e, "Failed to load plugin: " + plgname);
            return Optional.empty();
        }
        return Optional.of(plugin);
    }

    @Override
    public boolean saveState(Set<JrModule> modules, Path path) {
        if (!path.isAbsolute()) {
            path = EnvironmentInst.get().getConfiguration().getConfDir().resolve(path);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
            for (JrModule module : EnvironmentInst.get().getModuleManager().getModules()) {
                if (!modules.isEmpty() && !modules.contains(module)) continue;
                State state = new State();
                module.saveState(state);
                if (state.size() == 0) continue;
                writer.write(module.getPlugin().getPluginName() + "." + module.getName() + ":\r\n");
                for (Map.Entry ent : state.entrySet()) {
                    writer.write(" " + (String)ent.getKey() + ": \"" + ((String)ent.getValue()).replace("\"", "\\\"") + "\"\r\n");
                }
                writer.write("\r\n");
            }
        }
        catch (IOException e) {
            EnvironmentInst.get().printError(this.logger, e, new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean loadState(Set<JrModule> modules, Path path) {
        Map<Object, Object> save;
        if (!path.isAbsolute()) {
            path = EnvironmentInst.get().getConfiguration().getConfDir().resolve(path);
        }
        if ((save = ConfigurationYaml.loadYamlFileAsMap(path)) == null) {
            return false;
        }
        for (Object obj : save.keySet()) {
            String plgmod = obj.toString();
            int k = plgmod.indexOf(46);
            String plgname = plgmod.substring(0, k);
            String modname = plgmod.substring(k + 1);
            JrModule m = this.getModule(modname);
            if (m == null || !m.getPlugin().getPluginName().equals(plgname)) continue;
            State state = new State();
            Map savemap = (Map)save.get(obj);
            state.putAll(savemap);
            if (state.size() == 0) continue;
            m.loadState(state);
            this.env.printInfo(this.logger, modname, "Successfully imported state");
        }
        return true;
    }
}

