/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.RefGroup;
import promauto.jroboplc.core.tags.TagPlain;

public class RefItem {
    private JrModule module = null;
    private Tag tag = null;
    private Tag value = null;
    private final String modulename;
    private final String tagname;
    private String moduletagname = null;
    private boolean external = false;
    private boolean optional = false;

    public RefItem(RefGroup parent, String modulename, String tagname) {
        this.modulename = modulename;
        this.tagname = tagname;
    }

    public void prepare() {
        this.external = false;
        this.module = EnvironmentInst.get().getModuleManager().getModule(this.modulename);
        if (this.module == null) {
            this.moduletagname = (this.modulename.isEmpty() ? "" : this.modulename + '.') + this.tagname;
            this.external = true;
        }
        this.tag = null;
    }

    public boolean link() {
        if (this.tag != null) {
            if (this.tag.getStatus() == Tag.Status.Deleted) {
                this.prepare();
            } else {
                return true;
            }
        }
        if (this.external) {
            for (JrModule extmod : EnvironmentInst.get().getModuleManager().getModulesWithExternalTags()) {
                this.tag = extmod.getTagTable().get(this.moduletagname);
                if (this.tag == null) continue;
                this.module = extmod;
                break;
            }
            if (this.tag == null) {
                return false;
            }
        } else if (this.module == null || (this.tag = this.module.getTagTable().get(this.tagname)) == null) {
            return false;
        }
        this.value = TagPlain.create(this.tag);
        this.tag.copyValueTo(this.value);
        return true;
    }

    public boolean isLinked() {
        return this.tag != null;
    }

    public boolean read() {
        if (!this.isLinked()) {
            return false;
        }
        if (this.tag.equalsValue(this.value)) {
            return false;
        }
        this.tag.copyValueTo(this.value);
        return true;
    }

    public Tag getTag() {
        return this.tag;
    }

    public Tag getValue() {
        return this.value;
    }

    public JrModule getModule() {
        return this.module;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getInfo() {
        if (this.isLinked()) {
            return this.module.getName() + ":" + (this.external ? this.moduletagname : this.tagname) + " - ok";
        }
        return (this.external ? "?:" + this.moduletagname : this.modulename + ":" + this.tagname) + " - nolink" + (this.optional ? " (optional)" : "");
    }
}

