/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;

public class TagPlainDouble
extends TagPlain {
    double value;

    public TagPlainDouble(String name, double value) {
        super(name);
        this.value = value;
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.DOUBLE;
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getDouble() == this.value;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setDouble(this.value);
    }

    @Override
    public boolean getBool() {
        return this.value != 0.0;
    }

    @Override
    public int getInt() {
        return (int)this.value;
    }

    @Override
    public long getLong() {
        return (long)this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return "" + this.value;
    }

    @Override
    public void setBool(boolean value) {
        this.value = value ? 1.0 : 0.0;
    }

    @Override
    public void setOn() {
        this.value = 1.0;
    }

    @Override
    public void setOff() {
        this.value = 0.0;
    }

    @Override
    public void setInt(int value) {
        this.value = value;
    }

    @Override
    public void setLong(long value) {
        this.value = value;
    }

    @Override
    public void setDouble(double value) {
        this.value = value;
    }

    @Override
    public void setString(String value) {
        try {
            this.value = Double.parseDouble(value.trim());
        }
        catch (NumberFormatException e) {
            this.value = 0.0;
        }
    }
}

