/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.database;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractPlugin;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.plugin.database.FirebirdDatabaseModule;

public class DatabasePlugin
extends AbstractPlugin {
    private static final String PLUGIN_NAME = "database";
    private final Logger logger = LoggerFactory.getLogger(DatabasePlugin.class);

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginDescription() {
        return "database connectivity over jdbc";
    }

    @Override
    public JrModule createModule(String name, Object conf) {
        JrModule m = this.createDatabaseModule(name, conf);
        if (m != null) {
            this.modules.add(m);
        }
        return m;
    }

    public JrModule createDatabaseModule(String name, Object conf) {
        String type = this.env.getConfiguration().get(conf, "type", "").toLowerCase();
        FirebirdDatabaseModule m = null;
        switch (type) {
            case "firebird": {
                m = new FirebirdDatabaseModule(this, name);
                break;
            }
            default: {
                this.env.printError(this.logger, name, "Unknown database type:", type);
            }
        }
        if (m != null && !m.load(conf)) {
            return null;
        }
        return m;
    }
}

