/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.database;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.database.DatabaseModule;
import promauto.jroboplc.plugin.database.DbscrAction;
import promauto.jroboplc.plugin.database.DbscrActionDo;
import promauto.jroboplc.plugin.database.DbscrActionIf;

public class Dbscr {
    private final Logger logger = LoggerFactory.getLogger(Dbscr.class);
    private static Pattern patternActstr = Pattern.compile("(if|do)\\s+(.*)", 32);
    private static Pattern patternToken = Pattern.compile("(?<=\\{)\\w+(?=\\})");
    private String name;
    protected DatabaseModule database;
    private Map<String, String> params = new HashMap<String, String>();
    private Set<String> tokens = new HashSet<String>();
    private List<DbscrAction> actions = new ArrayList<DbscrAction>();
    private Environment env;

    public Dbscr(DatabaseModule database, String name) {
        this.database = database;
        this.name = name;
        this.env = EnvironmentInst.get();
    }

    protected DatabaseModule getDatabase() {
        return this.database;
    }

    public boolean load(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.actions.clear();
        for (Object obj : cm.toList(conf)) {
            Matcher m = patternActstr.matcher(obj.toString());
            if (m.find()) {
                DbscrAction da;
                String acttype = m.group(1);
                if (acttype.equals("if")) {
                    da = new DbscrActionIf();
                } else {
                    assert (acttype.equals("do"));
                    da = new DbscrActionDo();
                }
                if (((DbscrAction)da).init(this, m.group(2))) {
                    this.actions.add(da);
                    continue;
                }
            }
            this.env.printError(this.logger, "Bad format:", obj.toString());
            return false;
        }
        return true;
    }

    public Database.ScriptResult execute(Map<String, String> params) {
        this.params = params;
        Database.ScriptResult scriptResult = new Database.ScriptResult();
        scriptResult.success = true;
        scriptResult.executedDoCount = 0;
        scriptResult.positiveIfCount = 0;
        try (Statement st = this.database.getConnection().createStatement();){
            boolean res = true;
            for (DbscrAction ac : this.actions) {
                if (ac.isCondition()) {
                    res = ac.execute(st);
                    if (!res) continue;
                    ++scriptResult.positiveIfCount;
                    continue;
                }
                if (!res) continue;
                ac.execute(st);
                ++scriptResult.executedDoCount;
            }
            if (scriptResult.executedDoCount > 0 && this.database.logdbscr) {
                this.env.printInfo(this.logger, this.database.getName(), "Commiting " + scriptResult.executedDoCount + " actions");
            }
            this.database.commit();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.database.getName(), this.name);
            scriptResult.success = false;
            this.database.rollback();
        }
        if (!scriptResult.success || scriptResult.executedDoCount > 0 && this.database.logdbscr) {
            this.env.printInfo(this.logger, this.database.getName(), scriptResult.success ? "Script executed:" : "Script failed:", this.name, params != null && params.size() > 0 ? params.toString() : "");
        }
        this.params = null;
        return scriptResult;
    }

    public String injectParameters(String source) {
        this.tokens.clear();
        Matcher m = patternToken.matcher(source);
        while (m.find()) {
            this.tokens.add(m.group());
        }
        for (String token : this.tokens) {
            if (token.equals("schema")) continue;
            String value = this.getParam(token);
            source = source.replace('{' + token + '}', value);
        }
        if (this.tokens.contains("schema")) {
            String schema = this.getParam("schema");
            if (!schema.isEmpty()) {
                source = source.replaceAll("\\{schema\\}(?=\\w)", schema + this.database.getSchemaDelimiter());
                source = source.replace("{schema}", schema);
            } else {
                source = source.replace("{schema}", "");
            }
        }
        this.tokens.clear();
        return source;
    }

    private String getParam(String token) {
        if (this.params == null) {
            return "";
        }
        return this.params.getOrDefault(token, "");
    }
}

