/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.TagRepository;
import promauto.jroboplc.plugin.motohr.Context;
import promauto.jroboplc.plugin.motohr.CounterType;
import promauto.jroboplc.plugin.motohr.DataService;
import promauto.jroboplc.plugin.motohr.DataServiceImpl;
import promauto.jroboplc.plugin.motohr.Mach;
import promauto.jroboplc.plugin.motohr.MachGroup;
import promauto.jroboplc.plugin.motohr.MotohrPlugin;
import promauto.jroboplc.plugin.motohr.Stat;
import promauto.jroboplc.plugin.motohr.SysUtil;

public class MotohrModule
extends AbstractModule
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(MotohrModule.class);
    public static final String DBSCR_MOTOHR = "dbscr/dbscr.motohr.yml";
    public static final String MOTOHR_INIT_1 = "motohr.init1";
    public static final String TABLE_REPO = "MH_REPO";
    private TagRepository tagrepo;
    private Database database;
    private boolean needInit;
    private Context ctx = new Context();

    public MotohrModule(Plugin plugin, String name) {
        super(plugin, name);
        this.ctx.setModule(this);
        this.ctx.setDataService(new DataServiceImpl());
        this.ctx.setEnvironment(EnvironmentInst.get());
        this.ctx.setStat(new Stat(this.ctx));
        this.ctx.setSysUtil(new SysUtil(this.ctx));
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.ctx.databaseModuleName = cm.get(conf, "database", "db");
        try {
            for (Object confMachGroup : cm.toList(cm.get(conf, "machines"))) {
                this.ctx.machGroups.add(new MachGroup(this.ctx, confMachGroup));
            }
            this.ctx.stat.load();
            this.ctx.sysUtil.load();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            return false;
        }
        this.ctx.tagConnected = this.tagtable.createBool("connected", false);
        this.ctx.tagTime = this.tagtable.createRWLong("system.time", 0L);
        return true;
    }

    @Override
    public final boolean prepareModule() {
        boolean res;
        this.database = this.env.getModuleManager().getModule(this.ctx.databaseModuleName, Database.class);
        if (this.database == null) {
            this.env.printError(this.logger, this.name, "Database not found:", this.ctx.databaseModuleName);
            return false;
        }
        this.ctx.service.setDb(this.database);
        this.tagrepo = this.database.createTagRepository("", TABLE_REPO);
        this.addAsSignalListerToAllOthers();
        this.needInit = res = this.database.loadScriptFromResource(MotohrPlugin.class, DBSCR_MOTOHR) != null;
        return res;
    }

    @Override
    public void onSignal(JrModule sender, Signal signal) {
        if (signal.type == Signal.SignalType.CONNECTED && sender == this.database && !this.ctx.tagConnected.getBool()) {
            this.needInit = true;
        } else if (signal.type == Signal.SignalType.DISCONNECTED && sender == this.database) {
            this.ctx.tagConnected.setBool(false);
        } else if (signal.type == Signal.SignalType.RELOADED) {
            this.needInit = true;
        }
    }

    private void init() {
        this.ctx.tagConnected.setBool(false);
        if (this.database == null || !this.database.isConnected()) {
            return;
        }
        boolean res = this.database.executeScript((String)MOTOHR_INIT_1).success;
        if (res) {
            DataService svc = this.ctx.service;
            try (Statement st = svc.createStatement();){
                svc.startSync();
                res = this.tagrepo.init();
                CounterType.loadAll(this.ctx);
                MachGroup.initAll(this.ctx);
                this.ctx.stat.init();
                if (res) {
                    this.tagrepo.load(this.name, this.ctx.repoTags);
                }
                svc.finishSync();
                svc.commit();
                this.postSignal(Signal.SignalType.RELOADED);
                this.env.printInfo(this.logger, this.name, "Initialized");
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                svc.rollback();
            }
        }
        if (!res) {
            this.env.printError(this.logger, this.name, "Initialization error");
        }
        this.ctx.tagConnected.setBool(res);
        this.needInit = false;
    }

    public void raiseNeedInit() {
        this.needInit = true;
    }

    @Override
    public boolean executeModule() {
        if (this.database == null || !this.database.isConnected()) {
            return true;
        }
        if (this.needInit) {
            this.init();
        }
        if (this.ctx.tagConnected.getBool()) {
            try (Statement st = this.ctx.service.createStatement();){
                this.ctx.updateTime();
                Mach.executeAll(this.ctx);
                this.ctx.stat.execute();
                this.tagrepo.save(this.name, this.ctx.repoTags);
                this.tagrepo.persist();
                this.ctx.sysUtil.execute();
                this.ctx.service.commit();
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name, ", Last sql =", this.ctx.service.getLastSql());
                this.ctx.service.rollback();
                this.ctx.tagConnected.setBool(false);
                this.needInit = true;
            }
        }
        return true;
    }

    @Override
    public boolean closedownModule() {
        this.ctx.tagConnected.setBool(false);
        this.removeAsSignalListerFromAllOthers();
        return true;
    }

    @Override
    public String getInfo() {
        if (!this.enable) {
            return "disabled";
        }
        return String.format("%s%s machs=%d counters/types=%d/%d", this.ctx.tagConnected.getBool() ? "" : ANSI.redBold("NOT CONNECTED! "), this.ctx.databaseModuleName, this.ctx.machs.size(), this.ctx.machs.stream().mapToInt(mach -> mach.counters.size()).sum(), this.ctx.counterTypes.size());
    }

    @Override
    protected boolean reload() {
        MotohrModule tmp = new MotohrModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedown();
        this.copySettingsFrom(tmp);
        this.tagtable.copyValuesTo(tmp.tagtable);
        this.tagtable.removeAll();
        tmp.tagtable.moveTagsTo(this.tagtable);
        this.ctx = tmp.ctx;
        this.ctx.setModule(this);
        this.prepare();
        return true;
    }
}

