/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OmronV7Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OmronV7Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected TagRW tagReg0001;
    protected TagRW tagReg0002;
    protected Tag tagReg0020;
    protected Tag tagReg0021;
    protected Tag tagReg0022;
    protected Tag tagReg0023;
    protected Tag tagReg0024;
    protected Tag tagReg0027;
    protected Tag tagReg0028;
    protected Tag tagReg0029;
    protected Tag tagReg002A;

    public OmronV7Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagReg0001 = this.protocol.addWriteTag(1, this.tagtable.createRWInt("Reg.R0001", 0, 8));
        this.tagReg0002 = this.protocol.addWriteTag(2, this.tagtable.createRWInt("Reg.R0002", 0, 8));
        this.tagReg0020 = this.tagtable.createInt("Reg.R0020", 0, 8);
        this.tagReg0021 = this.tagtable.createInt("Reg.R0021", 0, 8);
        this.tagReg0022 = this.tagtable.createInt("Reg.R0022", 0, 8);
        this.tagReg0023 = this.tagtable.createInt("Reg.R0023", 0, 8);
        this.tagReg0024 = this.tagtable.createInt("Reg.R0024", 0, 8);
        this.tagReg0027 = this.tagtable.createInt("Reg.R0027", 0, 8);
        this.tagReg0028 = this.tagtable.createInt("Reg.R0028", 0, 8);
        this.tagReg0029 = this.tagtable.createInt("Reg.R0029", 0, 8);
        this.tagReg002A = this.tagtable.createInt("Reg.R002A", 0, 8);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagReg0001.acceptWriteValue();
            this.tagReg0002.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.sendWriteTags(16);
            if (result && (result = this.protocol.requestCmd3(1, 2))) {
                this.tagReg0001.setReadValInt(this.protocol.getAnswerWord(0));
                this.tagReg0002.setReadValInt(this.protocol.getAnswerWord(1));
            }
            if (result && (result = this.protocol.requestCmd3(32, 11))) {
                this.tagReg0020.setInt(this.protocol.getAnswerWord(0));
                this.tagReg0021.setInt(this.protocol.getAnswerWord(1));
                this.tagReg0022.setInt(this.protocol.getAnswerWord(2));
                this.tagReg0023.setInt(this.protocol.getAnswerWord(3));
                this.tagReg0024.setInt(this.protocol.getAnswerWord(4));
                this.tagReg0027.setInt(this.protocol.getAnswerWord(7));
                this.tagReg0028.setInt(this.protocol.getAnswerWord(8));
                this.tagReg0029.setInt(this.protocol.getAnswerWord(9));
                this.tagReg002A.setInt(this.protocol.getAnswerWord(10));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

